if the ontology is empty then this definition exactly yields the well-founded models according to (van Gelder et al. 1991). For more properties, as well **as motivation**
and intuitions on *MKNF*W F S **, the reader is referred to (Knorr et al. 2008).**

## 3 Xsb Prolog And The Coherent Description Framework

Our implementation of *MKNF*W F S **is based on XSB Prolog (**xsb.sourceforge.net)
for two reasons. First, XSB's tabling engine evaluates rules according to WFS, and ensures rule termination for programs and goals with the *bounded term-size property* 5**. Second, the implementation uses the prover from XSB's ontology management system, the Coherent Description Framework (CDF) (Swift and Warren 2003).**
CDF has been used in numerous commercial projects, and was originally developed as a proprietary tool by the company XSB, Inc 6**. Since 2003, CDF has been**
used to support extraction of information about aircraft parts from free-text data fields, about medical supplies and electronic parts from web-sites and electronic catalogs, and about the specifics of mechanical parts from scanned technical drawings.

Also, CDF is used to maintain screen models for graphical user interfaces that are driven by XSB and its graphics package, XJ (www.xsb.com/xj.aspx)**. We discuss** features of CDF that are relevant to the implementation described **in Section 4.** Type-0 and Type-1 Ontologies **All classes in CDF are represented by terms of**
the form *cid(Identifier, Namespace)***, instances by terms of the form** oid(Identifier, Namespace)**, and relations by terms of the form** *rid(Identifier, Namespace)***, where** Identifier and *Namespace* **can themselves be any ground Prolog term.**
Commercial use has driven CDF to support efficient query answering **from Prolog**
for very large knowledge bases. A key to this is that ontologies in CDF **can have**
a restricted, tractable form. *Type-0* **ontologies do not allow representation of negation or disjunction within the ontology itself, and implicitly use the closed-world**
assumption. As such, Type-0 ontologies resemble a frame-based representation more than a description logic, and do not add any complexity to query evaluation beyond that of WFS. Support for query answering motivates the representation of Type-0 ontologies. The predicate isa/**2 is used to state inclusion: whether the inclusion** is a subclass, element of, or subrelation depends on the type of the **term (not all**
combinations of types of terms are allowed in a CDF program). Relational atoms in CDF have the form:
- hasAttr(T erm1, Rel1, T erm2) which has the meaning T erm1 ⊑ ∃Rel1**.T erm**2; - allAttr(T erm1, Rel1, T erm2) with the meaning T erm1 ⊑ ∀Rel1**.T erm**2;
- **along with other forms that designate cardinality constraints on relations.**
Figure 1 presents some DL Axioms and their Type-0 counterparts, **where namespace information has been omitted for readability. The fact that Type-0 ontologies**