
## A Goal-Directed Implementation Of Query Answering For Hybrid Mknf 15

starts with all conclusions that can be drawn from the program alone 8**. Given these**
minor differences, taking the function *Tableau*(O**) as correct w.r.t. the consequence** relation of the description logic in use, and taking the function SLG(P**) as correct** w.r.t. the least model semantics of definite logic programs, it is easy to see that if I
is the set of all individuals in the knowledge base then the union of the Dn and Rn at the fixed point exactly coincides with the least fixed point of TK**. Furthermore,** as long as the program P **respects DL-safety, MKNF rules are lazily grounded with** respect to the set of individuals I**. In fact, given a DL-safe set of MKNF rules, and** a set of queries grounded with the individuals in I**, the evaluation of the queries**
results in a complete grounding of the rules, and so the fixed point is guaranteed in a finite number of steps.

Definition 8 captures certain aspects of how the rules and the ontology use each other to derive new knowledge in *CDF-Rules***, via an alternating computation between the rules and the ontology. However it does not capture cases in which the**
relevant set of individuals changes (i.e. it does not deal with changes **in the set**
I), or the presence of default negation in rule bodies. With regard to **relevant individuals, since it is possible both to define n-ary predicates in rules and roles in**
the ontology, a query may depend on several individuals. Therefore, the fixed point computation must take into account the entire set of individuals that the query depends on. This is done by tabling information about each individual in **the set of** individuals relevant to the query. This set may increase throughout **the fixed point** iteration as new dependency relations between individuals (including equality) are discovered. The iteration stops when it is not possible to derive anything else about these individuals, i.e., when both the set of individuals and the classes and roles of those individuals have reached a fixed point. The details of this iterative increase in the set of considered individuals can be found in the algorithm of Figure 2, which also addresses default negation and its interplay with first-order negation.

The following example considers the presence of default negation in rule bodies.

Example 4 Consider the following knowledge base:
K fourth(X) ← p(X), not third(X). F ourth ⊑ **F if th** K third(X) ← p(X), K second(X). F irst ⊑ **Second**
K f irst(**callback**).

p(**callback**).

In this example a predicate fourth(X**) is defined as the default negation of**
third(X). Since fourth(X**) is defined in the rules, the negation is** *closed world*, that is, fourth(X) should only succeed if it is not possible to prove **third**(X). Consequently, if we employed SLG resolution blindly, an iteration where the truth of second(callback**) had not been made available to the rules from the ontology might**
mistakenly fail the derivation of third(callback) and so succeed fourth(**callback**).