Likewise, the rules may pass to the ontology knowledge, that after **some iterations,** no longer applies - in this case if the ontology were told that fourth(**callback**)
was true, it would mistakenly derive *Fifth*.

Example 4 illustrates the need to treat default negation carefully, as the truth of default literals requires re-evaluation when new knowledge is inferred. Recall the manner in which the operators ΓK and Γ′K **of Definition 6 address the problem of**
closed-world negation. Roughly, one step in ΓK (or Γ′K**) is defined as the application**
of TK until reaching a fixed point. Applying Γ′K followed by ΓK **is a monotonic**
operation and thus is guaranteed to have a least fixed point. In each dual application of ΓK and Γ′K **two different models follow - a monotonically increasing model of**
true atoms (i.e. true predicates and propositions), and a monotonically decreasing model of non-false atoms.

In a similar way, the implementation of *CDF-Rules* **makes use of two fixed points:**
an *inner* fixed point where we apply Definition 8 corresponding to TK**; and an** *outer* fixed point for the evaluation of nots, corresponding to ΓK (and Γ′K**). In the outer**
iteration, the evaluation of closed-world negation is made by a reference to the previous model obtained by ΓK**. Thus in** *CDF-Rules*, not(A**) succeeds if, in the**
previous *outer* iteration, A **was not proven.**

## Example 5

To illustrate the need to apply two fixed points, consider the knowledge base below and the query c(X):
K c(X) ← p(X), K a(X), not b(X). A ⊑ B
K a(**object**).

p(**object**).

When evaluating the query c(X), X is first bound to object by p**, and then the**
nested iteration begins. The inner iteration follows the steps of Definition 8, and since these operators are defined only for definite rules, each negative body literal in a rule such as p(X**) is evaluated according to its value in the previous** *outer* **fixed** point, or is simply evaluated as *true* **in the first outer iteration. (As we will see,** this is done lazily by *CDF-Rules***). The first stage of the inner iteration computes** R0 = {a(object), p(object), c(object)} **(Definition 8) via the rules; and computes via** the ontology D0 = ∅, as O 6|= A**. In the second inner stage the rules achieve the same** fixed point as in the first, so R1 = R0, but the ontology derives **object** : B in D1.

After sharing this knowledge, there is nothing else to infer by either **components,**
and we achieve the first inner fixed point with:

## T1 = {A(Object), B(Object), C(Object), P(**Object**)}

So now, the second outer iteration starts the computation of the **inner iteration**
again and, in this iteration, negative literals in the rules are evaluated w.r.t. T1**. As a**
consequence, c(object) fails, since b(object) ∈ T1**. The fixed point of the second inner**
iteration contains p(object), a(object) and b(object**), which is in fact the correct**
model for object. Afterwards, a final outer iteration is needed to to determine that