one can define several axioms about countries (e.g. Scandinavian countries are European countries; Norway is a Scandinavian country; etc). Moreover, one can also model in the ontology knowledge that is certain, in the sense that it does not allow for exception. With such certain knowledge, first-order logics deduction is what is desired. For example, in this scenario, one could state that Scandinavian countries are always considered safe countries. All of this can be easily represented by an ontology defined in a Description Logic (DL) language (Baader et al. 2007)1**(1).**
ScandinavianCountry ⊑ **EuropeanCountry**
Norway : **ScandinavianCountry**
ScandinavianCountry ⊑ **SafeCountry**
(1)
Besides these axioms about countries, one may want to specify some additional knowledge, e.g. for defining conditions about whether or not to inspect entering shipments based on their country of origin. For example, we may want to state that one should inspect any vessel containing a shipment coming from a country that is not guaranteed to be safe. Note here that the closed world assumption is needed to define such a statement. In fact, intuitively one wants to assume that, if one is unsure whether given country is safe, then (at least for the sake **of this statement)** the country should be considered unsafe and an inspection performed. When using description logic with classical negation this behavior would not be obtained, as a condition ¬SafeCountry(country**) would only be true in case one knows for sure** that the country is not safe. However, this statement can be easily expressed by using a (non-monotonic) rule with default negation2 **as in (2).**

## Inspect(X) ← Hasshipment(X, Country), Not Safecountry(Country). (2)

Such rules are non-monotonic in the sense that further knowledge **– in this case**
about safety of countries - can invalidate previous conclusions about inspection. This kind of non-monotonic rule is quite useful to specify default knowledge that may be subject to exceptions. In this sense rule (2) can be seen as **stating that by** default shipments should be inspected, but an exception to this default rule are shipments coming from safe countries.

Note that defining some statements about a predicate using default rules does not necessarily mean that all **statements defining that predicate should be default rules.** For example, we may want to state that diplomatic shipments are not **subject to** inspection, regardless their country of origin. Here no default reasoning is involved.

Moreover, negation here is not the default negation of logic programming, but rather classical negation. Such a statement could be modeled using normal **logic programs**
extended with explicit negation (Gelfond and Lifschitz 1990) with the **rule:**
¬inspect(X) ← diplomaticShipment(X) (3)