isa_int ( oid ( Obj , NS ) , cid ( Class , NS1 )):-
ground ( Obj ) , ground ( Class ) ,!,
Call =.. [ Class , Obj ], /* Call = Class ( Obj ) */
lastKnown ( Call ).

/* Find all possible classes for Obj if called with superclass argument uninstantiated */
isa_int ( oid ( Obj , NS ) , cid ( Class , NS )):-
ground ( Obj ) , var ( Class ) ,!,
definedClass ( Call , Class , Obj ) ,
lastKnown ( Call ).

hasAttr_int ( oid ( Obj1 , NS ) ,rid ( Role , NS1 ) ,oid ( Obj2 , NS2)):-
ground ( Obj1 ) , ground ( Obj2 ) , ground ( Role ) ,!,
Call =.. [ Role , Obj1 , Obj2 ], /* Call = Role ( Obj1 , Obj2 ) */
last_known ( Call ).

/* Find all possible rules for Obj if called with role argument uninstantiated */
hasAttr_int ( oid ( Obj1 , NS ) ,rid ( Role , NS1 ) ,oid ( Obj2 , NS2)):-
ground ( Obj1 ) , ground ( Obj2 ) , var ( Role ) ,!,
definedRole ( Call , Role , Obj1 , Obj2 ) ,
last_known ( Call ).

Fig. 6. Callbacks from the ontology component to the rules component current implementation it is the programmer's responsibility to check **for this**
condition. The current implementation also does not check that the Ai predicates (i.e. the ones not under known/1 or dlnot/**1) are not defined in the**
ontology. If a programmer opts to not precede the predicate by known/**1 or** dlnot/**1, any definition for the predicate in the ontology is simply ignored.**
- cdf extensional.P **– comprising ordinary ontology facts and concepts defined**
over the CDF syntax.

- cdf intensional.P **– containing predicates allowing the ontology to access**
information in the rules as in Figure 6. In addition, the file may contain other intensional rules to lazily access information from a database, off of the semanitc web, or from other sources external to *CDF-Rules*.

Example 6 The knowledge base of Example 1 can be easily coded in *CDF-Rules* as:
% rules inspect (X) :- hasShipment (X ,C) , dlnot ( safeCountry (C)).

% cdf_extensional isa_ext ( cid ( scandinavianCtr , ont ) , cid ( safeCountry , ont )). isa_ext ( cid ( scandinavianCtr , ont ) , cid ( EuropeanCtr , ont )).

isa_ext ( oid ( norway , ont ) ,cid ( scandinavianCtr , ont )).

necesscond_ext ( cid ( DiplomaticShipt , ont ) ,neg ( cid ( inspect , ont ))).

Note that the ontological portion is Type-1, due to the use of necessCond/2.