
## 4.2.4 Discussion

As described, *CDF-Rules* **implements query answering to hybrid MKNF knowledge**
bases, and tries to reduce the amount of relevance required in the **fixed point operation. Relevance is a critical concept for query answering in practical systems,**
however a poorly designed ontology or rules component can work against one another if numerous individuals depend on one another through DL roles. In such a case the relevance properties of our approach will be less powerful; however in such a case, a simple query to an ontology about an individual will be inefficient in itself.

The approach of *CDF-Rules* **cannot solve such problems; but it can make query** answering as relevant as the underlying ontology allows.

We do not present here a formal proof of soundness and completeness for our algorithm, since this would require the full presentation of the formal derivation procedures on which both XSB-Prolog and CDF implementations rely. **However, we**
have given an informal argument along with our description by referring to complementarity between the implementation and the bottom-up definition of *MKNF***W F S**.

In particular, there is a close correspondence between the inner fixed points of our computation represented in Definition 8 and the RK, DK and TK **operators of Definition 4; a correspondance between the the actions of** known/3 **in Figure 3 and**
the transformation of Definition 5 to ensure the coherency between classical and default negation; and also a correspondance between our outer fixed points and the operators ΓK / Γ′K**. As a result, one can view our goal-driven implementation as**
an optimization of the bottom-up approach where the computation **is limited to** the set of *relevant* **objects, and where the evaluation of positive predicates and the** handling of iterations is performed by the use of SLG resolution.

Further optimizations of the described approach are possible. First is to designate a set of atoms whose value is defined *only* **in the ontology: such atoms would require**
tableau proving, but could avoid the fixed point check of **computeF ixedP oint/**1.

Within computeF ixedP oint/1 another optimization would be to maintain dependencies among individuals. Intuitively, if individual I1 **depended on individual** I2 but not the reverse, a fixed point for I2 **could be determined before that of** I1. However, these optimizations are fairly straightforward elaborations of *CDF-Rules* as presented.

## 5 Conclusions

In this paper we have described the implementation of a query-driven system, CDF-Rules**, for hybrid knowledge bases combining both (non-monotonic) rules**
and a (monotonic) ontology. The system answers queries according to *MKNF***W F S**
(Knorr et al. 2008) and, as such, is also sound w.r.t. the semantics defined in (Motik and Rosati 2007) for Hybrid MKNF knowledge bases. The definition of MKNFW F S **is parametric on a decidable description logic (in which the ontology is written), and it is worth noting that, as shown in (Knorr et al. 2008), the**
complexity of reasoning in *MKNF*W F S **is in the same class as that in the decidable**
description logic; a complexity result that is extended to a query-driven approach