or, having the possibility to use an ontology formalized as a fragment **of first-order** logic, with a statement:
DiplomaticShipment ⊑ ¬Inspect (4)
However, these two representations of the statement above are not equivalent. In particular, with axiom 4 one can conclude that a given shipment is not diplomatic whenever one knows, by some other rule, that it should be inspected; this is not the case with rule 3. The behavior of rules with explicit negation can be **easily**
modeled by using ontologies; for that it suffices to create a new concept standing for the explicit negation, say NonInspect**, replacing the explicitly negated literal in** the rule by this new concept, and adding the axiom NonInspect ≡ ¬Inspect**. On** the contrary, with programs extended with explicit negation one cannot obtain the full expressivity that is obtained with some of the DL-based languages for ontologies, simply because some of these languages belong to a higher complexity class.

Another important feature not supported by explicit negation but typically supported by DL-based ontologies, is the possibility of using existential **quantification**
as illustrated in Example 2 below.

The foregoing example briefly illustrates some advantages of combining features of ontologies with features of logic programming-like rules, and of doing so in a way that allows knowledge about instances to be fully inter-definable between rules and an ontology (as happens with the predicate inspect/**1 above, which is both defined** in the rules and the ontology).

In fact, this combination of ontology and rule languages has gained particular importance in the context of the Semantic Web (Horrocks et al. 2006). In this context, a family of languages for representing background knowledge in the **Web, OWL 2**
(Hitzler et al. 2009), has been recommended by the World Wide Web Consortium (W3C). OWL 2 languages are based on Description Logics (Baader et **al. 2007),** which, as in the example above, employ open-world assumption. In addition, the rule interchange language RIF (Morgenstern et al. 2010) has recently been formally recommended to the W3C. RIF has many similarities with the logic programming language used in the example above, and adopts the closed-world assumption.

The existence of both rules and ontology languages should make it possible to combine open and closed world reasoning, and this combination is indeed important in several domains related to the Semantic Web. As a further example where this combination is desired, consider the large case study described in
(Patel et al. 2007), containing millions of assertions concerning matching patient records to clinical trials criteria. In this case study, open world reasoning is needed in deductions about domains such as radiology and laboratory data: **unless a lab**
or radiology test asserts a negative finding no arbitrary assumptions about the results of the test can be made (e.g. we can only be certain that some patient does not have a specific kind of cancer if the corresponding test is known to have negative result). However, as observed in (Patel et al. 2007), closed **world reasoning**
can and should be used with pharmacy data to infer that a patient is not on a medication if this is not asserted. The work of (Patel et al. 2007) applies only open