world reasoning but claims that the usage of closed world reasoning in **pharmacy** data would be highly desirable. Similar situations occur e.g. in matchmaking using Semantic Web Services (cf. (Grimm and Hitzler 2007)), where again a **combination**
of ontology languages relying on open-world reasoning, with rule languages relying on closed-world reasoning is considered highly desirable.

Several factors influence the decision of how to combine rules and ontologies into a hybrid knowledge base. The choice of semantics for the rules, **such as the**
answer-set semantics (Gelfond and Lifschitz 1990) or the well-founded semantics
(WFS) (van Gelder et al. 1991), can greatly affect the behavior of the knowledge base system. The answer-set semantics offers several advantages: for instance, description logics can be translated into the answer-set semantics providing a solid basis for combining the two paradigms (Baral 2002; Eiter et al. 2004a; Swift 2004; Motik 2006). On the other hand, WFS is weaker than the answer-set semantics (in the sense that it is more skeptical), but has the advantages of lower complexity and its ability to be evaluated in a query-oriented fashion, which have **led to its**
integration into Prolog systems. Another possibility of maintaining the complexity under reasonable bounds for Semantic Web applications, is to limit the **expressivity of both the ontological part of the knowledge base, and of the rules. For**
instance, (Cal`ı et al. 2012) considers variants of Datalog that allow for existential quantification in rule heads along with other features to support a restricted form of ontological reasoning, yet restrict the rule syntax to obtain tractability.

Keeping to the general form of logic programming rules, but maintaining the complexity of reasoning under reasonable bounds, several formalisms **have concerned**
themselves with combining ontologies with general WFS rules (Drabent and Ma luszynski 2007; Eiter et al. 2004b; Knorr et al. 2008). Among these, the Well-Founded Semantics for Hybrid MKNF knowledge bases (*MKNF*W F S **), introduced in (Knorr et al. 2008)**
and overviewed in Section 2 below, is the only one that allows knowledge **about instances to be fully inter-definable between rules and an ontology that is taken as a**
parameter of the formalism. *MKNF*W F S **assigns a well-founded semantics to Hybrid**
MKNF knowledge bases, is sound w.r.t. the original semantics of (Motik and Rosati 2007)
and, as in (Motik and Rosati 2007), allows the knowledge base to have both closedand open-world (classical) negation. For comparisons of *MKNF*W F S **with the approaches for combining rules with ontologies mentioned above, see (Knorr et al. 2011).**

## Example 2

The following fragment, adapted from an example in (Motik and Rosati 2007),
concerning car insurance premiums illustrates several properties of *MKNF***W F S**.

The ontology consists of the following axioms, which state that M arried and NonM arried **are complementary concepts, that anyone who is not married is high** risk, and that anyone with a spouse is married:
NonM arried ≡ ¬**M arried**
¬M arried ⊑ **HighRisk**

$\boxed{\phantom{\frac{1}{1}}}$
∃Spouse.⊤ ⊑ **M arried.**
MThe rule base consists of the following rules, which state that anyone who is not