Definition 3 Let K be a DL-safe hybrid MKNF knowledge base. We obtain K+ from K **by adding**
an axiom ¬P ⊑ NP for every DL atom P **which occurs as head in at least one rule** in K where NP is a new predicate not already occurring in K**. Moreover, we obtain**
K∗from K+ by adding not NP(t1, . . . , tn**) to the body of each rule with a DL**
atom P(t1, . . . , tn**) in the head.**
In K+, NP represents ¬P (with its corresponding arguments) while K∗**introduces**
a restriction on each rule with such a DL atom in the head, saying intuitively that the rule can only be used to conclude the head if the negation of its head cannot be proved4. For example, to guarantee in Example 1 that proving falsity of **Inspect**
for some shipment (via the ontology) enforces default negation of Inspect **for that**
shipment, one would build K+ by adding to the ontology the axiom ¬**Inspect** ⊑
N Inspect (where N Inspect **is a new symbol not appearing elsewhere), and in**
K∗ all original rules with inspect(X**) in the head would be transformed by adding**
not n inspec(X**) to the body. In this case, the rule in (2) would be transformed to:** K inspect(X) ← K hasShipment(X, Country), not safeCountry(**Country**),
not n **inspect**(X).

We continue by recalling the definition in (Knorr et al. 2008) of an operator TK
to allow conclusions to be drawn from positive hybrid MKNF knowledge bases (i.e.

knowledge bases where rules have no default negation). Definition 4 For K a positive DL-safe hybrid MKNF knowledge base, RK, DK, and TK are defined on subsets of KA(K∗**) as follows:**

RK(S) = S ∪ {K H | K contains a rule of the form (1) such that K Ai ∈ S for each 1 ≤ i ≤ n} DK(S) = {K ξ | K ξ ∈ KA(K∗) and O ∪ SbDL |= ξ} ∪ {K Q(b1, . . . , bn) | K Q(a1, . . . , an) ∈ S \ SDL, K Q(b1, . . . , bn) ∈ KA(K∗), and O ∪ SbDL |= ai ≈ bi for 1 ≤ i ≤ n} TK(S) = RK(S) ∪ DK(S)
RK derives consequences from the rules in a way similar to the classical TP **operator**
of definite logic programs, while DK obtains knowledge from the ontology O**, both**
from non-DL-atoms and the equalities occurring in O, where the ≈ **operator defines**
a congruence relation between individuals.

The operator TK **is shown to be monotonic in (Knorr et al. 2008) so, by the**
Knaster-Tarski theorem, it has a unique least fixed point, denoted lfp(TK**), which**
is reached after a finite number of iteration steps.

The computation of the well-founded models follows the alternating fixed point construction (van Gelder 1989) of the well-founded semantics for **logic programs.** This approach requires turning a hybrid MKNF knowledge base into a positive one to make TK **applicable.**
4 Note that K+ and K∗ are still hybrid MKNF knowledge bases, so we only refer to K+ and K∗
explicitly when it is necessary.