PBproblem A representation of a pseudo-Boolean output problem in the same way of the class CNFproblem**. This**
class allows to produce an instance of the input problem in a form that allows to solve it using a pseudo-Boolean satisfiability solver.

## Encoder

This interface represents an encoder, i.e., a class that contains the resources for translating constraints.

Encoder2cnf This interface represents an encoder which produces a cnf **formula as output. The available implementations will be presented in section 3.**
Encoder2pb This interface represents an encoder which produces a list of pseudo-Boolean constraints as output.

## Pbbasicencoder

This encoder puts the input problem in a format that allows it **to be solved using a pseudo-Boolean**
satisfiability solver.

## 2.1.3 The Internal Block

This part includes the internal resources allowing the communication between the input and the output block, as well as the implementation of the translation process.

## Rawconstraint

The internal representation for input constraints. Any class which implements the interface **Constraint**
must provide a method producing an array of such internal constraints. Currently, any instance of the class PseudoBooleanLeqConstraint produces only one instance of RawConstraint**, but a class** PseudoBooleanEqConstraint **could be implemented in a way to manage input constraints of the form**
a1x1+· · ·+anxn = b**. Such a constraint could either be represented as two internal inequality constraint**
or one internal equality constraint.

## Outputconstraint

A generic output constraint.

## Clause

Implementation of OutpuConstraint **as a propositional clause. Contains resources that can be used** by the cnf encoders to produce output clauses, which will be converted **into strings by the class**
CNFproblem.

## Pbconst

Implementation of OutpuConstraint **as a pseudo-Boolean constraint. Contains resources that can be** used by the pb **encoder to produce output pseudo-Boolean constraints, which will be converted into**
strings by the class **CNFproblem**.

## Outputconstraints

A set of output constraints resulting from the translation process, which are aimed to be converted into strings to produce the output problem.

CNFformula A set of Clauses represented as instances of the class **Clause**.

PBformula A set of pseudo-Boolean constraints represented as instances of the class **PBconst**.