
## 2.2 User Resources

This section presents the main classes and methods allowing **one to implement the resources provided by**
BoolVar/pb.

## 2.2.1 Input Block User Resources

InputModel.InputModel()
Create a new input model, which can be seen as a container for the input constraints.

Variable.Variable()
Create a new propositional variable, which is aimed to be used in an input constraint.

## Variable.Getposlit()

Returns a positive literal v from the current variable v. If the literal v **does not exists, it is created**
thanks to the constructor of the class Literal**, else the reference of the existing literal is returned.** v is aimed to be used in input constraints.

## Variable.Getneglit()

Returns a negative v literal from the current variable v. If v **does not exists, it is created thanks to the** constructor of the class Literal, else the reference of the existing literal is returned. v **is aimed to be**
used in input constraints.

## Variable.Getlit(Boolean Sign)

Returns a literal v or v, according to the value of sign, from the current variable v**. If the required**
literal does not exists, it is created thanks to the constructor of the class Literal**, else the reference of**
the existing literal is returned.

## Literal.Literal(Variable V, Boolean S)

Create a new literal, which is aimed to be used in an input constraint. In order to avoid redundancies, literals must be preferably created thanks to the methods getNegLit and getPosLit **provided by the** class **Variable**.

BoolVar.setTag(int tag1) BoolVar.setTag(int tag1,int tag2)

## Boolvar.Settag(Int Tag1,Int Tag2,...,Tag4)

Sets the tags that will be assigned to the input constraints that will be created before the next call of setTag**. The tags are arbitrary integers that will be assigned to encoders in a way to specify which** encoder(s) must be used for translating each input constraint.

## Boolvar.Makeleq(Int[] C, Literal[] L, Int B) Boolvar.Makeleq(Biginteger[] C, Literal[] L, Biginteger B)

Create a new pseudo-Boolean inequality constraint c[0]l[0]+· · ·+c[n−1]l[n−1] ≤ b (where n **is the size**
of the arrays c and l) from an array c of coefficients, an array l of literals, and a bound b**. The resulting** constraint is aimed to be added to the input model tanks to the method **InputModel.addConstraint**.

InputModel.addConstraint(Constraint q)
Adds a new constraint to the current input model.