
## 2.2.2 Output Block User Resources Pbproblem.Pbproblem()

Creates a new output problem as a pseudo-Boolean satisfiability problem.

PBproblem.PBproblem()
Creates a new output problem as a propositional satisfiability problem.

PBproblem.assignEncoder(int tag, Encoder x)
Assigns the encoder x to the given tag. Several encoders can be assigned to the same **tag by multiple**
calls to this method.

PBproblem.read(InputModel m)
Reads the input model m in a way to translate each input constraint of m **with the related encoders.** This method must be used only one time, after all the input constraints are added to the input model.

PBproblem.getOutput()
Returns the output problem as a string. This method must be called after the method InputModel.read.

## 3 Available Encodings

The current version of BoolVar/pb **includes 5** cnf **encoders for pseudo-Boolean inequality constraints.** The underlying encoding methods can be classified in different categories with respect to the size of the output formula and the inference power of unit propagation (which is the basic filtering technique used in the sat **solvers) on this formula.** Any cnf **encoding which produces a** cnf **formula polynomially sized (exponentially sized, respectively) with**
respect to the number of variables in the input constraint is said to be polynomial (exponential**, respectively).**
Any cnf **encoding is said to be a** pac **(like propagating arc consistency) encoding if and only if applying unit** propagation on the resulting formula fixes the same variables as restoring arc consistency on the corresponding input constraint. It is said to be a pic **(like propagating inconsistency) encoding if and only if applying** unit propagation on the resulting formula produces the empty clause if restoring arc consistency on the corresponding input constraint detects an inconsistency. Any pac **encoding is necessarily a** pic **one.**

## 3.1 Cnfdirectencoder

This simple exponential and pac **encoding is briefly described in [2]. It can be seen as a variant of the** bdd based encoding introduced in [1] where each path of the bdd **is encoded with a clause in a way that no**
additional variable is required.

## 3.2 Cnfbddencoder

This exponential pac bdd**-based encoding was introduced in [1]. It generally produces a smaller formula** that the direct encoding, because it uses additional variables corresponding to each node of the bdd**, which**
allows to factorize identical subgraphs. Unlike the direct **one, this encoding is polynomial for cardinality** constraints, i.e., when all the coefficients are 1.

## 3.3 Cnflinearencoder

This linear encoding is described in [4]. It is inspired from the encoding introduced in [5]. It is neither pac nor pic**. His main interest is the size of the produced formulae.**