
## Supporting New Encodings

Some encodings dedicated to cardinality constraints will be added. Because cardinality constraints are a special case of pseudo-Boolean ones, the pseudo-Boolean encoders can of course deal with cardinality constraints. But there exists specific encodings which could be more efficient and/or compact for cardinality constraints. In addition, some of the already implemented encodings could be improved and / or hybridized in a way to reduce the size / efficiency ratio of the resulting output formulae.

## Coupling With A Solver

The goal is to provide the resources for solving the output problem thanks to the solver sat4J [3], in a way to build stand alone applications.

## References

[1] Olivier Bailleux, Yacine Boufkhad, and Olivier Roussel. A translation of pseudo boolean constraints to sat. JSAT**, 2(1-4):191–200, 2006.**

[2] Olivier Bailleux, Yacine Boufkhad, and Olivier Roussel. New encodings of pseudo-boolean constraints into cnf. In SAT**, pages 181–194, 2009.**
[3] Daniel Le Berre and Anne Parrain. The sat4j library, release 2.2. JSAT**, 7:59–64, 2010.**
[4] Niklas Eén and Niklas Sörensson. Translating pseudo-boolean constraints into sat. JSAT**, 2(1-4):1–26,**
2006.

[5] J. P. Warners. A linear-time transformation of linear inequalities into conjunctive normal form. Information Processing Letters**, 1968.**