solve SAT problems efficiently is an essential issue in AI. To evaluate SAT algorithms, Mitchell et al. [21] introduced a model for generating random SAT instances, which can produce hard instances as it was claimed. Compared with SAT instances from industrial area, this model can obtain large amount of instances whose size and difficulty can be controlled by parameters. As a result, it has become a canonical benchmark to test various SAT algorithms. Meanwhile, theoretical analyses on the random k-SAT model have been made [3], for example, the properties of phase transitions have been identified that are widely used to analyze average computational complexity. In the model discussed in [21], there are 3 parameters k, n, m that are employed to generate SAT instances, where k is the length of clauses, n is the number of variables, and m is the number of clauses. We use a ratio r to represent m/n. Instances are produced by generating m clauses uniformly and independently, where each clause is generated by selecting k variables without replacement from n variables and negating each variable with probability 0.5. All clauses generated are of the same length. 

 Empirical and theoretical studies have demonstrated that there are easy-hard-easy patterns when solving the random k-SAT instances. Lots of experiments have shown that the soluble-to-insoluble phase transition will occur when r is up to a fixed value, for example, r is about 4.3 in 3-SAT [21], and mean runtimes for finding a solution by SAT algorithms are often extremely high for solving instances in the phase transition region. As r increases from 0, mean runtimes increase first but decrease when r is larger than the value at the transition point. However, it seems to be difficult to locate transition points of k-SAT by theoretical proof, as only lower and upper bounds have been found for the points [3]. Similar phenomenon also exists in \#SAT [11], which is a counting problem. In the general case, \#SAT is \#P-complete, which is considered to be harder than NP-complete. Algorithms for solving this problem count the number of solutions in the given SAT instance. Mean runtimes of several \#SAT solvers have been investigated, and the results show that those solvers also suffer the easy-hard-easy pattern, but the hardest regions of those \#SAT algorithms are different. For instance, it was reported that an algorithm, called Counting Davis-Putnam [22], reaches its peak runtime when r=1.2 on the experiments of \#3-SAT, while the peak point of another algorithm, called Decomposing Davis-Putnam [23], occurs when r=1.5. In the following sections, we show that the knowledge complication also undergoes the easy-hard-easy pattern. 

## Basic Conjecture

Let nr Pk be a random k-SAT instance generated with n variables and rn clauses, and let ( ) nr *XL k* P be the size of the compilation result, where L is the target language to which nr Pk is compiled (we regard the number of nodes as the size, when L is OBDD or d-DNNF). 

Definition 1. *Given n, r, k and a target language L, average size* ( ( )) nr EX P *L k is defined as follows:* 
( ( )) ( ( )) | | nr nr nr EX P X P P *Lk Lk k* = ∑
where nr Pk is any problem in the set made up of all possible instances that can be generated by the random SAT model with parameters n, rn, k, and | | nr *Pk is the number of all possible instances.* 
 Because the structures of the target languages are very complex, it seems hard to analyze average behaviors (i.e. ( ( )) nr EX P L k ) of them theoretically. However, the following conjecture seems 