

![0_image_0.png](0_image_0.png) 

## Solution Interchangeability

We then discuss the relationships between the multi-interchangeable paths and the solution interchangeability. Solution interchangeability of CSPs has been studied for decades. Freuder [25] investigated the interchangeability deeply, where various forms of interchangeability were proposed. According to his definitions, two values *a, b* for a variable x are *fully interchangeable* if every solution to the CSP containing the assignment *<x, a>* remains a solution when b is substituted for a, and vice versa. Here we extend the solution interchangeability by the following definitions: a SAT instance with n variables is *fully multi-interchangeable* if there exists more than one variable such that values 0 and 1 are interchangeable for every solution; a partial assignment is *weak interchangeable* if it can be extended to a solution by assigning any value (0 or 1) to each unsigned variable; a partial assignment is weak multi-interchangeable if it is *weak interchangeable* and its length is no more than n-2 (n is the total number of variables in an instance). Clearly, a multi-interchangeable path implies that there must exist at least one multi-interchangeable partial assignment, but a multi-interchangeable partial assignment does not mean there exists a multi-interchangeable path. That is, the definition of the multi-interchangeable path is more rigorous than that of the weak multi-interchangeable partial assignment. On the other hand, it can be seen that the definition of the multi-interchangeable path is looser than that of fully multi-interchangeable SAT instance. So the multi-interchangeable path is a more complex form of solution interchangeability between full and weak solution interchangeability. We can also see that the solution interchangeability in SAT instances is related to implicants [26]. A term κ is an implicant of the formula φ if and only if κ|=φ. Implicants are a dual form of the implicates. The interchangeable paths mean that there exist some implicants on the path, while an implicant may not appear in the form of an interchangeable path. In fact, when we use OBDD, d-DNNF and DFA as the target languages, the key technique during the compilation is to convert solutions into a compact form. Because of the compaction, compilation results can be reduced to reasonable sizes for on-line processing. The compaction can reduce the representation of symmetric solutions by incorporating some common parts of these solutions. So the interchangeable structure of solutions determines the effectiveness of the compaction, and thus the transition of the solution interchangeability mentioned above causes the sizes of compilation results suffering the easy-hard-easy 