# Rational Deployment Of Csp Heuristics

David Tolpin and **Solomon Eyal Shimony**
Ben-Gurion University of the Negev, Beer Sheva, Israel
{tolpin,shimony}@cs.bgu.ac.il

## Abstract

Heuristics are crucial tools in decreasing search effort in varied fields of AI. In order to be effective, a heuristic must be efficient to compute, as well as provide useful information to the search algorithm.

However, some well-known heuristics which do well in reducing backtracking are so heavy that the gain of deploying them in a search algorithm might be outweighed by their overhead.

We propose a rational metareasoning approach to decide when to deploy heuristics, using CSP backtracking search as a case study. In particular, a value of information approach is taken to adaptive deployment of solution-count estimation heuristics for value ordering. Empirical results show that indeed the proposed mechanism successfully balances the tradeoff between decreasing backtracking and heuristic computational overhead, resulting in a significant overall search time reduction.

## 1 Introduction

Large search spaces are common in artificial intelligence, heuristics being of major importance in limiting search efforts. The role of a heuristic, depending on type of search algorithm, is to decrease the number of nodes expanded (e.g. in A* search), the number of candidate actions considered
(planning), or the number of backtracks in constraint satisfaction problem (CSP) solvers. Nevertheless, some sophisticated heuristics have considerable computational overhead, significantly decreasing their overall effect [Horsch and Havens, 2000; Kask *et al.*, 2004], even causing *increased* total runtime in pathological cases. It has been recognized that control of this overhead can be essential to improve search performance; e.g. by selecting which heuristics to evaluate in a manner dependent on the state of the search [Wallace and Freuder, 1992; Domshlak *et al.*, 2010].

We propose a rational metareasoning approach [Russell and Wefald, 1991] to decide when and how to deploy heuristics, using CSP backtracking search as a case study.

The heuristics examined are various *solution count estimate* heuristics for value ordering [Meisels *et al.*, 1997; Horsch and Havens, 2000], which are expensive to compute, but can significantly decrease the number of backtracks. These heuristics make a good case study, as their overall utility, taking computational overhead into account, is sometimes detrimental; and yet, by employing these heuristics adaptively, it may still be possible to achieve an overall runtime improvement, even in these pathological cases. Following the metareasoning approach, the value of information (VOI) of a heuristic is defined in terms of total search time saved, and the heuristic is computed such that the expected net VOI is positive.

We begin with background on metareasoning and CSP
(Section 2), followed by a re-statement of value ordering in terms of rational metareasoning (Section 3), allowing a definition of VOI of a value-ordering heuristics - a contribution of this paper. This scheme is then instantiated to handle our case-study of backtracking search in CSP (Section 4),
with parameters specific to value-ordering heuristics based on solution-count estimates, the main contribution of this paper.

Empirical results (Section 5) show that the proposed mechanism successfully balances the tradeoff between decreasing backtracking and heuristic computational overhead, resulting in a significant overall search time reduction. Other aspects of such tradeoffs are also analyzed empirically. Finally, possible future extensions of the proposed mechanism are discussed (Section 6), as well as an examination of related work.

## 2 Background 2.1 Rational Metareasoning

In rational metareasoning [Russell and Wefald, 1991], a problem-solving agent can perform *base-level* actions from a known set {Ai}. Before committing to an action, the agent may perform a sequence of *meta-level* "deliberation" actions from a set {Sj}. At any given time there is an "optimal" baselevel action, Aα, that maximizes the agent's expected utility:

$$\alpha=\arg\operatorname*{max}_{i}\sum_{k}P(W_{k})U(A_{i},W_{k})$$
k
P(Wk)U(Ai, Wk) (1)
where {Wk} is the set of possible world states, U(Ai, Wk) is the utility of performing action Aiin state Wk, and P(Wk) is the probability that the current world state is Wk.

A meta-level action provides information and affects the choice of the base-level action Aα. The *value of information* (VOI) of a meta-level action Sj is the expected difference between the expected utility of Sj and the expected utility