
$$\Gamma(S_{j}))-\mathbb{E}_{P^{j}}(U(A_{\alpha})))$$

of the current Aα, where P is the current belief distribution
about the state of world, and P
jis the belief-state distribution
of the agent after the computational action Sj is performed, given the outcome of Sj :
V (Sj ) = EP (EP j (U(Sj )) − EP j (U(Aα))) (2)
Under certain assumptions, it is possible to capture the dependence of utility on time in a separate notion of *time cost*
C. Then, Equation (2) can be rewritten as:
V (Sj ) = Λ(Sj ) − C(Sj ) (3)
$${\mathrm{where~the~}}i n t r i n s i c~v a l u e~o f i o r m a t i o n$$
is the expected difference between the *intrinsic expected utilities* of the new and the old selected base-level action, computed after the meta-level action is taken.
$$\Lambda(S_{j})=\mathbb{E}_{P}\left(\mathbb{E}_{P^{j}}(U(A_{\alpha}^{j}))-\mathbb{E}_{P^{j}}(U(A_{\alpha}))\right)$$
$$V(S_{j})=\Lambda(S_{j})-C(S_{j})$$

## 2.2 Constraint Satisfaction

A constraint satisfaction problem (CSP) is defined by a set of variables X = {X1, X2*, ...*}, and a set of constraints C = {C1, C2*, ...*}. Each variable Xi has a non-empty domain Di of possible values. Each constraint Ciinvolves some subset of the variables—the scope of the constraint— and specifies the allowable combinations of values for that subset. An assignment that does not violate any constraints is called *consistent* (or *a solution*). There are numerous variants of CSP
settings and algorithmic paradigms. This paper focuses on binary CSPs over discrete-values variables, and backtracking search algorithms [Tsang, 1993].

A basic method used in numerous CSP search algorithm is that of maintaining arc consistency (MAC) [Sabin and Freuder, 1997]. There are several versions of MAC; all share the common notion of *arc consistency*. A variable Xiis arcconsistent with Xj if for every value a of Xi from the domain Dithere is a value b of Xj from the domain Dj satisfying the constraint between Xi and Xj . MAC maintains arc consistency for all pairs of variables, and speeds up backtracking search by pruning many inconsistent branches.

CSP backtracking search algorithms typically employ both variable ordering [Tsang, 1993] and value ordering heuristics. The latter type include *minimum conflicts* [Tsang, 1993],
which orders values by the number of conflicts they cause with unassigned variables, *Geelen's promise* [Geelen, 1992]
- by the product of domain sizes, and *minimum impact* [Refalo, 2004] orders values by relative impact of the value assignment on the product of the domain sizes.

Some value-ordering heuristics are based on solution count estimates [Meisels *et al.*, 1997; Horsch and Havens, 2000; Kask *et al.*, 2004]: solution counts for each value assignment of the current variable are estimated, and assignments
(branches) with the greatest solution count are searched first. The heuristics are based on the assumption that the estimates are correlated with the true number of solutions, and thus a greater solution count estimate means a higher probability that a solution be found in a branch, as well as a shorter search time to find the first solution if one exists in that branch.

[Meisels *et al.*, 1997] estimate solution counts by approximating marginal probabilities in a Bayesian network derived from the constraint graph; [Horsch and Havens, 2000] propose the *probabilistic arc consistency* heuristic (pAC) based on iterative belief propagation for a better accuracy of relative solution count estimates; [Kask *et al.*, 2004] adapt Iterative Join-Graph Propagation to solution counting, allowing a tradeoff between accuracy and complexity. These methods vary by computation time and precision, although all are rather computationally heavy. Principles of rational metareasoning can be applied independently of the choice of implementation, to decide when to deploy these heuristics.

$$({\mathfrak{I}})$$
$$(4)$$

## 3 Rational Value-Ordering

The role of (dynamic) value-ordering is to determine the order of values to assign to a variable Xk from its domain Dk, at a search state where values have already been assigned to (X1*, ..., X*k−1). We make the standard assumption that the ordering may depend on the search state, but is not recomputed as a result of backtracking from the initial value assignments to Xk: a new ordering is considered only after backtracking up the search tree above Xk.

Value ordering heuristics provide information on future search efforts, which can be summarized by 2 parameters:
- Ti—the expected time to find a solution containing assignment Xk = yki or verify that there are no such solutions;
- pi—the "backtracking probability", that there will be no solution consistent with Xk = yki.

These are treated as the algorithm's subjective probabilities about future search in the current problem instance, rather than actual distributions over problem instances. Assuming correct values of these parameters, and independence of backtracks, the expected remaining search time in the subtree under Xk for ordering ω is given by:

$$T^{s|\omega}=T_{\omega(1)}+\sum_{i=2}^{|D_{k}|}T_{\omega(i)}\prod_{j=1}^{i-1}p_{\omega(j)}\tag{5}$$

In terms of rational metareasoning, the "current" optimal base-level action is picking the ω which optimizes T
s|ω.

Based on a general property of functions on sequences
[Monma and Sidney, 1979], it can be shown that T
s|ω is minimal if the values are sorted by increasing order of Ti 1−pi
.

A candidate heuristic H (with computation time T
H) generates an ordering by providing an updated (hopefully more precise) value of the parameters Ti, pi for value assignments Xk = yki, which may lead to a new optimal ordering ωH,
corresponding to a new base-level action. The total expected remaining search time is given by:

$$T=T^{H}+E[T^{s|\omega_{H}}]$$

s|ωH ] (6)
Since both T
H (the "time cost" of H in metareasoning terms) and T
s|ωH contribute to T, even a heuristic that improves the estimates and ordering may not be useful. It may be better not to deploy H at all, or to update Ti, pi only for some of the assignments. According to the rational metareasoning approach (Section 2.1), the intrinsic VOI Λi of estimating Ti, pi for the ith assignment is the expected decrease