
| Model       | MNIST   | MNIST-BINARY   | USPS   |
|-------------|---------|----------------|--------|
| MLP         | 1.82%   | 2.01%          | 5.74%  |
| MLP + L2    | 1.66%   | 2.20%          | 5.6%   |
| MLP + Noise | 1.33%   | 1.7%           | 4.85%  |
| MLP + Jacob | 1.31%   | 1.65%          | 4.85%  |
| MLP + N + J | 1.19%   | 1.51%          | 4.6%   |

to explicitly calculate the norm of the high order derivatives because their number of components increases exponentially, instead our approach proposes an approximation of the Hessian term that allows you to simultaneously control the magnitude of both the Jacobian and hessian norms independently.

## 9.3 The Other Terms Induced By The Noise

As we have seen in the equation 17, the added noise does not yield only in a penalty on the norm of the successive derivatives of the mapping function and it is somehow unclear how these terms behave during gradient descent since they are not constrained to be positive. In a supervised setting, it is empirically feasible to drive those terms to zero because of the small dimensionality of the target points, whereas in a multidimensional regression task such as the reconstruction objective of an auto-encoder it is often impossible to achieve a "near" zero minimization of the cost with a first order optimization such as a stochastic gradient descent. The reader should note that the approximation of the noisy cost is valid when the number of corrupted inputs tends to infinity, though in practise this is never the case. It would be interesting to do an estimate of the difference between the terms induced by the noise and the real values of the term in function of the number of corrupted samples.

## 10 Conclusion

We have shown how to obtain a better generalization performance using a regularization term that adds a marginal computational overhead compared to the traditional approach. Using a Taylor expansion of the cost function, we also showed that by adding noise to the input of the regularization term we are able to penalize with a greater magnitude the norm of the higher order derivatives of the model avoiding the need to explicitly calculate them, which would be obviously computationally prohibitive. Initial results suggests that different parametric models clearly benefit from this approach in terms of predicting outof-sample points. It would be interesting to investigate how this regularization approach would behave when used with non-parametric models such as gaussian-mixtures.