included, then h must be in the set. We also consider extensions to logic programs, such as choice rules and cardinality rules. A *choice rule* of the form
{h1, . . . , hk} ← a1, . . . , am, not am+1**, . . . , not a**n allows for the nondeterministic choice over atoms in
{h1**, . . . , h**k}. A *cardinality rule* of the form h ← k{a1, . . . , am, not am+1**, . . . , not a**n}
infers h if k or more literals in the set {a1**, . . . , a**m, not am+1**, . . . , not a**n} are satisfied. The semantics of choice rules and cardinality rules is given through program transformations (cf. [Simons *et al.*, 2002]). Note that aggregations and other forms of set constructions are also common in ASP. However, we will limit ourselves to the above concepts as they are expressive enough for what follows. Also note that, although answer set semantics is propositional, atoms in A can be constructed from a first-order signature.

The logic program over A is then obtained by a *grounding* process, systematically substituting all occurrences of first-order variables with terms formed by function symbols and constants given through the signature. The task of ASP systems is to compute answer sets for logic programs. A successful framework is conflict-driven nogood learning (CDNL;[Gebser *et al.*, 2007]). It reflects conditions from program rules in a set of *nogoods*, and describes ASP inference as unit-propagation on nogoods to determine logical consequences.

Constraint Satisfaction and Consistency We want to use ASP to model and solve CSP. Formally, a CSP is a triple
(**V, D, C**) where V is a finite set of *variables*, each v ∈ V has an associated finite *domain* dom(v) ∈ D, and C is a set of constraints. A *constraint* c is a pair (RS , S) where RS is a k-ary relation, denoted **range**(c), on the variables in S ∈ V
k, denoted **scope**(c). Given a *(constraint variable) assignment* A : V →Sv∈V
dom(v), for a constraint c with **scope**(c) =
S = (v1**, . . . , v**k) define A(S) = (A(v1)**, . . . , A**(vk)) and call c *satisfied* if A(S) ∈ **range**(c). Define the set of constraints satisfied by A as satC(A) = {c | A(**scope**(c)) ∈
range(c), c ∈ C}. A *binary* constraint c has |**scope**(c)| = 2.

For instance, the constraint v1 6= v2 ensures that v1 and v2 take different values. An n-ary constraint c has parametrised scope. For instance, ALL-DIFFERENT ensures that a set of variables, |**scope**(c)| = n, take all different values. As any non-binary constraint, this can be *decomposed* into binary constraints, i.e., O(n 2) constraints vi 6= vj for **i < j**. However, as we shall see in the following, such reformulation can hinder inference.

An assignment A is a *solution* to a CSP iff it satisfies all constraints in C. Typically, CP systems use backtracking search to explore assignments in a search tree. In a search tree, each node represents an assignment to some variables, child nodes are obtained by selecting an unassigned variable and having a child node for each possible value for this variable, and the root node is empty. Every time a variable is assigned a value, *constraint propagation* is executed, pruning the set of values for the other variables, i.e., enforcing a certain type of local consistency such as arc, bound, range, or domain consistency. A binary constraint c is *arc consistent* iff a variable v1 ∈ **scope**(c) is assigned any value d1 ∈
dom(v1), there exists a compatible value d2 ∈ dom(v2) for the other variable v2. An n-ary constraint c is domain consistent iff a variable vi ∈ **scope**(c) = {v1**, . . . , v**n}
is assigned any value di ∈ dom(vi), there exist compatible values in the domains of all the other variables dj ∈
dom(vj ), 1 ≤ j ≤ **n, j** 6= i. Bound and range consistency are defined for constraints over finite intervals. A
constraint c is *bound consistent* iff a variable viis assigned di ∈ {min(dom(vi)), max(dom(vi))} there exist consistent values between the minimum and maximum domain value for all the other variables in the scope of the constraint, called a bound support. A constraint is *range consistent* iff a variable is assigned any value in its domain, there exists a bound support. Range consistency is in between domain and bound consistency, where domain consistency is the strongest of the three local consistency properties.

Constraint Answer Set Programming Constraint logic
programming naturally merges CP and logic programming,
while preserving the advantages of either approach to modelling and solving CSP. Formally, a *constraint logic program*
is a logic program P over an alphabet distinguishing regular
atoms A and constraint atoms C, such that head(r) ∈ A for
each r ∈ P [Gebser *et al.*, 2009b]. A function γ : C → C associates constraint atoms with constraints. (The set C stems
from the definition of CSP.) For sets of constraints C
′ ⊆ C
define γ(C
′
) = {γ(c) | c ∈ C
′}. Given a constraint logic
program P over A and C, and an assignment A, a set X ⊆ A
is a *constraint answer set* of P with respect to A iff X is an
answer set of the *constraint reduct* [Gebser *et al.*, 2009b]:
P
A = {head(r) ← **body**(r)|A | r ∈ P,
$ad(r)\gets body(r)|_{A}\mid r\in P$,  $\gamma(body(r)^{+}|_{c})\subseteq sat_{C}(A)$,  $\gamma(body(r)^{-}|_{c})\cap sat_{C}(A)=\emptyset$.  

## The Idea In Our Translation-Based Approach To Constraint Answer Set Solving Is To Compile A Constraint Logic Program Into
A (Normal) Logic Program By Adding An Asp Reformulation Of
Constraint Variables And All Constraints That Appear In The Constraint Logic Program. This Allows Us To Apply Cdnl To Compute Constraint Answer Sets. A Key Advantage Is That Nogood
Learning Techniques Can Exploit Constraint Interdependencies Since All Variables Will Be Shared Between Constraints. This
Can Improve Propagation Between Constraints. Our Reformulations Also Provides A Propagator For The Negation Of A Constraint. 3 Reformulating Casp Into Asp

We now present four ASP encodings for variables and constraints over finite domains. All constraints c are reified via atoms sat(c), and **violate**(c), indicating whether c is satisfied or violated, respectively. To ensure consistency, i.e., either sat(c) or **violate**(c) is in an answer set, we post sat(c) ← **not violate**(c)
violate(c) ← **not sat**(c)
for every constraint c. Other representations, e.g., using choice rules, are also possible. To save the reader from multi-