
| n             | S   | B1                     | B3                  | B         | R3       | R     | ezcsp clingcon gecode   |     |     |
|---------------|-----|------------------------|---------------------|-----------|----------|-------|-------------------------|-----|-----|
| 10            | 5.4 | 0.7                    | 0.1                 | 0.0       | 0.2      | 0.0   | 1.8                     | 1.4 | 0.9 |
| 11 46.5       | 3.5 | 1.0                    | 0.0                 | 1.9       | 0.0 16.7 | 15.2  | 9.0                     |     |     |
| 12 105.0 14.8 | 3.9 | 0.0                    | 2.6                 | 0.1 183.9 | 172.5    | 104.1 |                         |     |     |
| 13            | -   | 91.4 25.4 0.1 30.4 0.0 | -                   | -         | -        |       |                         |     |     |
| 14            | -   | -                      | 125.0 0.0 196.9 0.1 | -         | -        | -     |                         |     |     |
| 15            | -   | -                      | -                   | 0.1       | -        | 0.1   | -                       | -   | -   |

Table 1: Runtime results in seconds for pigeon hole problems.

linked to (8) as follows:
$$r(v,l,u)\gets not\;b(v,l-1),b(v,u)\tag{12}$$ $$\perp\gets r(v,l,u),b(v,l-1)$$ (13) $$\perp\gets r(v,l,u),not\;b(v,u)\tag{14}$$
Corollary 3 Unit-propagation on (8–14) enforces bound consistency on ALL-DIFFERENT in O(nd2) *down any branch* of the search tree.

## 4 Experiments

We have conducted experiments on hard combinatorial problems modelled with ALL-DIFFERENT constraints that stem from CSPLib [Gent and Walsh, 1999]. Experiments consider different options in our translation-based approach to constraint answer set solving. We denote the support encoding by S, the bound encoding by B, and the range encoding by R.

To explore the impact of small Hall intervals, we also tried Bk and Rk, an encoding with only those cardinality rules
(8) for which u − l + 1 ≤ k. The consistency achieved by Bk and Rk may be weaker than bound and range consistency, respectively, when **k < n**. We also include the hybrid CASP systems *clingcon* (0.1.2), and *ezcsp* (1.6.9) in our empirical analysis. While *clingcon* extends the ASP system *clingo* (2.0.2) with the CP solver *gecode* (2.2.0), *ezcsp* combines the grounder *gringo* (2.0.3) and ASP solver *clasp* (1.3.0) with *sicstus* (4.0.8) as CP solver. (Note that the system clingo combines the grounder *gringo* and ASP solver *clasp* in a monolithic way.) To provide a representative comparison with *clingcon* and *ezcsp*, we have applied *clingo* (2.0.3)
to the encodings in our translation-based approach. To compare the performance of constraint answer set solvers against traditional CP, we also report results of *gecode* (3.2.0). Its heuristic for variable selection was set to a smallest domain as in *clingcon*. All experiments were run on a 2.00 GHz PC
under Linux. We report results in seconds, where each run was limited to 600 s time and 1 GB RAM.

Pigeon Hole Problems The famous *pigeon hole problem* is to show that it is not possible to assign n pigeons to n−1 holes if each pigeon must be assigned a distinct hole. As can be seen from the results shown in Table 1, our bound and range encodings perform significantly faster compared to weaker encodings and the other options using filtering algorithms for the ALL-DIFFERENT constraint that achieve arc consistency on its binary decomposition. However, as can be expected on such problems, detecting large Hall intervals is essential.

| %                                                                                                                                                                                                                                                               | S        | B       | R       | ezcsp   | clingcon   | gecode   | gecodeB   |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------|---------|---------|---------|------------|----------|-----------|
| 10 2.6 8.2 7.3                                                                                                                                                                                                                                                  | 29.6 (7) | 9.7 (4) | 2.2 (4) | 0.5 (1) |            |          |           |
| 20 2.4 8.0 7.2 21.3 (20)                                                                                                                                                                                                                                        | 6.2 (5)  | 5.0 (4) | 0.9 (3) |         |            |          |           |
| 30 2.3 7.9 7.1 10.3 (30) 12.9 (13)                                                                                                                                                                                                                              | 2.9 (13) | 1.1 (5) |         |         |            |          |           |
| 35 2.3 7.9 7.0 21.6 (24) 11.2 (17) 14.1 (13)                                                                                                                                                                                                                    | 6.2 (7)  |         |         |         |            |          |           |
| 40 2.3 7.8 6.9 51.6 (29) 23.1 (22) 11.7 (20)                                                                                                                                                                                                                    | 5.7 (9)  |         |         |         |            |          |           |
| 45 2.3 7.8 6.8 36.3 (35) 14.7 (28) 17.7 (25)                                                                                                                                                                                                                    | 6.3 (13) |         |         |         |            |          |           |
| 50 2.3 7.7 6.8 36.1 (50) 21.2 (37) 25.1 (32)                                                                                                                                                                                                                    | 6.3 (18) |         |         |         |            |          |           |
| 55 2.3 7.6 6.7 61.4 (51) 24.4 (44) 19.6 (41) 30.9 (29) 60 2.2 7.5 6.6 60.2 (63) 31.4 (56) 36.0 (51) 27.2 (35) 70 2.2 7.1 6.0 70.0 (66) 30.2 (50) 28.0 (45) 17.0 (27) 80 2.1 6.7 5.5 16.2 (18) 4.2 (18) 17.2 (13) 7.0 (7) 90 2.1 6.7 5.5 1.4 2.6 (1) 0.4 (1) 3.2 |          |         |         |         |            |          |           |

Table 2: Average times over 100 runs on quasigroup completion problems. Timeouts, if any, are given in parenthesis.

Quasigroup Completion A *quasigroup* is an algebraic structure over n elements and can be represented by an n×nmultiplication table such that each element in the structure occurs exactly once in each row and each column of the table. The *quasigroup completion problem* is to show whether a partially filled table can be completed to a multiplication table of a quasigroup. We have included models for *gecode* that enforce bound and domain consistency on ALL-DIFFERENT,
denoted *gecode*B and *gecode*D, respectively, in our experiments. Table 2 gives the runtime for solving QCP of size n = 20. The left-most column gives the ratio of preassigned entries. The results demonstrate phase transition behaviour in the systems ezcsp, clingcon, *gecode*, and *gecode*B, while our ASP encodings and *gecode*D (not shown) solve all problems within seconds. We conclude that learning constraint interdependencies as in our approach (using CDNL) is sufficient to tackle quasigroup completion, i.e., specialised algorithms that enforce domain consistency are not necessary.

Quasigroup Existence The *quasigroup existence problem* is to determine the existence of certain interesting classes of quasigroups with some additional properties
([Fujita *et al.*, 1993]). The properties are represented by axioms \#1 - \#7 in the direct encoding. In *ezcsp* and *gecode*,
we additionally use constructive disjunction. Their logic programming equivalent are integrity constraints, exploited in the options S, Bk, Rk and *clingcon*. As for *ezcsp* and *clingcon* on benchmark classes \#1 to \#4, our resuls presented in Table 3 suggest that both constructive disjunction and integrity constraints have a similar behaviour. However, our encodings benefit again from learning constraint interdependencies, resulting in runtimes that outperform all other systems including *gecode* on the hardest problems.

Graceful Graphs A labelling of the nodes in a graph (**V, E**) is *graceful* if it assigns a unique label from the integers in [0, |E|] such that, when each edge is labelled with the distance between its nodes' labels, the resulting edge labels are all different. The graceful graph problem is to determine the existence of such a labelling. We use auxiliary variables for edge labels. Their relation