used to extract information from the KB, whereas TELL **operations aim at changing the KB according to new knowledge acquired over the domain. In other**
words, TELL **operations should be able to cope with the** evolution of the KB.

There are two types of evolution operators, corresponding to inserting, and deleting chunks of knowledge, respectively. In the case of insertion, the aim is to incorporate new knowledge into the KB, and the corresponding operator should be defined in such a way to compute a consistent KB that supports the new knowledge. In the case of deletion, the aim is to come up with a consistent KB where the retracted knowledge is not valid. In both cases, the crucial aspect to take into account is that evolving a consistent knowledge base should not introduce inconsistencies. We point out that a different approach would be to allow inconsistencies in the KB, and then resorting to sophisticated quesy answering mechanisms, tolerant to such inconsistencies (see, for example, [1,12], but this is outside the scope of the approach presented here.

Notice that, while ASK **operations have been investigated in detail by the DL**
community, existing DL reasoners do not provide explicit services for KB evolution. Nevertheless, many recent papers demonstrate that the interest towards a well-defined approach to KB evolution is growing significantly [9,14,7,15,6].

Following the tradition of the work on knowledge revision and update [11],
all the above papers advocate some minimality criterion in the changes of the KB that must be undertaken to realize the evolution operations. In **other words,**
the need is commonly perceived of keeping the distance between the **original KB** and the KB resulting from the application of an evolution operator minimal. There are two main approaches to define such a distance, called model-based and formula-based**, respectively. In the model-based approaches, the result of an** evolution operation applied to the KB K **is defined in terms of a set of models,** with the idea that such a set should be as close as possible to the models of K. One basic problem with this approach is to characterize the language **needed to** express the KB that exactly captures the resulting set of models. **Conversely,** in the formula-based approaches, the result is explicitly defined in terms of a formula, by resorting to some minimality criterion with respect to the **formula** expressing K**. Here, the basic problem is that the formula constituting the result** of an evolution operation is not unique in general.

In this paper, we study the problem of DL KB evolution, by focusing our attention to scenarios characterized by the following elements:
1. We consider the case where the evolution affects only the instance level of the KB, i.e., the ABox. In other words, we enforce the condition that the KB resulting from the application of the evolution operators has the **same**
TBox as the original KB (similarly to [14,7]).

2. We aim at a situation where the KB resulting from the evolution can be expressed in the same DL as the original KB. This is coherent with our goal of providing the foundations for equipping DL systems with evolution operators: indeed, if a DL system S **is able to manage KBs expressed in a**
DL L, the result of evolving such KBs should be expressible in L.