In the identification assertions, π **denotes a** path**, which is an expression built**
according to the following syntax rule:
π −→ S | B? | π1 ◦ π2 where S **denotes an atomic role, the inverse of an atomic role, or an atomic** attribute, π1 ◦π2 denotes the composition of the paths π1 and π2, and B**?, called** test relation, represents the identity relation on instances of the concept B**. In**
our logic, identification assertions are local, i.e., at least one πi ∈ {π1, ..., πn} has length 1, i.e., it is an atomic role, the inverse of an atomic role, or an atomic attribute. In what follows, we only refer to IDs which are local.

A concept inclusion assertion expresses that a (basic) concept B **is subsumed**
by a (general) concept C**. Analogously for the other types of inclusion assertions. Inclusion assertions that do not contain (resp. contain) the symbols '**¬'
in the right-hand side are called positive inclusions **(resp.** negative inclusions). Attribute functionality assertions are used to impose that attributes are actually functions from objects to domain values. Finally, an ID (id B π1, ..., πn**) asserts** that for any two different instances a,b of B, there is at least on πi **such that** a and b differ in the set of their πi**-fillers. Note that IDs can be used to assert**
functionality of roles. Specifically, the assertion (id ∃Q− Q−**) imposes that** Q is functional.

The set of positive (resp., negative) inclusions in T **will be denoted by** T
+
(resp., T
−), whereas the set of identification assertions in T **will be denoted by**
Tid.

A DL-LiteA,id ABox A is a finite set of assertions of the form A(a), P(**a, b**),
and U(a, v), where A, P, and U are as above, a and b **are object constants in** S,
and v **is a value constant in** S.

Example 1. **We consider a portion of the Formula One domain. We know that**
official drivers (OD) and test drivers (T D) are both team members (TM**), and**
official drivers are not test drivers. Every team member is a member of (mf) a exactly one team (F T **), and every team has at most one official driver. Finally,** no race director (RD) is a member of a team. We also know that s **is the official**
driver of team t1, that b is a test driver, and that p **is a team member. The**
corresponding DL-LiteA,id-KB K is:

$\begin{array}{l}\bot=\exists m\,j\\ l,\,\neg T T\end{array}$
$$\begin{array}{r l}{O D\subseteq X M}&{{}_{T}D\supseteq}\\ {T M\subseteq\neg F T\ \exists m_{f}}\\ {O D(s)}&{{}_{m f(s,t_{1})}}\end{array}$$

## T : Od ⊑ Tm T D ⊑ Tm Od ⊑ ¬T D Rd ⊑ ¬Tm Tm ⊑ ∃Mf Tm ⊑ ¬F T ∃Mf ⊑ Tm ∃Mf − ⊑ F T (Id Od Mf) (**Id F T Mf** −) A: Od(S) Mf(S, T1) T D(B) Tm(P)

We conclude this section with a brief discussione on the complexity of reasoning about a DL-LiteA,id-KB hT , Ai**. Satisfiability can be checked in polynomial**
time with respect to |T \ Tid| and |A|, and in NP with respect to |Tid|**. Moreover,**
if hT , Ai is satisfiable, then answering a query q posed to hT , Ai **can be done** in polynomial time with respect to |T | and |A|**, and in NP with respect to** |q|.

Finally, clT (A) can be computed in quadratic time with respect to |T | and |A|.