# Learning Invariant Features Through Local Space Contraction

Salah Rifai, Xavier Muller, Xavier Glorot, Gr´egoire Mesnil Yoshua Bengio and Pascal Vincent April 22, 2011 Dept. IRO, Universit´e de Montr´eal. Montr´eal (QC), H3C 3J7, Canada Technical report 1360

## Abstract 1

We present in this paper a novel approach for training deterministic auto-encoders. We show that by adding a well chosen penalty term to the classical reconstruction cost function, we can achieve results that equal or surpass those attained by other regularized auto-encoders as well as denoising auto-encoders on a range of datasets. This penalty term corresponds to the Frobenius norm of the Jacobian matrix of the encoder activations with respect to the input. We show that this penalty term results in a localized space contraction which in turn yields robust features on the activation layer. Furthermore, we show how this penalty term is related to both regularized auto-encoders and denoising encoders and how it can be seen as a link between deterministic and non-deterministic auto-encoders. We find empirically that this penalty helps to carve a representation that better captures the local directions of variation dictated by the data, corresponding to a lower-dimensional non-linear manifold, while being more invariant to the vast majority of directions orthogonal to the manifold. Finally, we show that by using the learned features to initialize a MLP, we achieve state of the art classification error on a range of datasets, surpassing other methods of pre-training.

## 1 Introduction

A recent topic of interest1in the machine learning community is the development of algorithms for unsupervised learning of a useful representation. This automatic discovery and extraction of features is often used in building a deep hierarchy of features, within the contexts of supervised, semi-supervised, or unsupervised modeling. See Bengio (2009) for a recent review of Deep Learning algorithms. Most of these methods exploit as basic building block algorithms for learning one level of feature extraction: the representation learned at one level is used as input for learning the next level, etc. The objective is that these representations become *better* as depth is increased, but *what defines a good* representation? It is fairly well understood what PCA or ICA do, but much 1see NIPS'2010 Workshop on Deep Learning and Unsupervised Feature Learning arXiv:1104.4153v1 [cs.AI] 21 Apr 2011