tation is faithful, i.e., can be used to reconstruct the input example. Hence the directions that *resist* to this contracting pressure (strong invariance to input changes) are the directions present in the training set. Indeed, if the variations along these directions present in the training set were not preserved, neighboring training examples could not be distinguished and properly reconstructed. Hence the directions where the contraction is strong (small ratio, small singular values of the Jacobian matrix) are also the directions where the model believes that the input density drops quickly, whereas the directions where the contraction is weak (closer to 1, larger contraction ratio, larger singular values of the Jacobian matrix) correspond to the directions where the model believes that the input density is flat (and large, since we are near a training example).

We believe that this contraction penalty thus helps the learner carve a kind of mountain supported by the training examples, and generalizing to a ridge between them. What we would like is for these ridges to correspond to some directions of variation present in the data, associated to underlying factors of variation. How far do these ridges extend around each training example and how flat are they? This can be visualized comparatively with the analysis of Figure 1, with the contraction ratio for different distances from the training examples.

Note that different features (elements of the representation vector) would be expected to have ridges (i.e. directions of invariance) in different directions, and that the "dimensionality" of these ridges (we are in a fairly high-dimensional space) gives a hint as to the local dimensionality of the manifold near which the data examples congregate. The singular value spectrum of the Jacobian informs us about that geometry. The number of large singular values should reveal the dimensionality of these ridges, i.e., of that manifold near which examples concentrate. This is illustrated in Figure 2, showing the singular values spectrum of the encoder's Jacobian. The CAE by far does the best job at representing the data variations near a lower-dimensional manifold, and the DAE is second best, while ordinary auto-encoders (regularized or not) do not succeed at all in this respect.

What happens when we stack a CAE on top of another one, to build a deeper encoder? This is illustrated in Figure 3, which shows the average contraction ratio for different distances around each training point, for depth 1 vs depth 2 encoders.Composing two CAEs yields even more contraction and even more non-linearity, i.e. a sharper profile, with a flatter level of contraction at short and medium distances, and a delayed effect of saturation (the bump only comes up at farther distances). We would thus expect higher-level features to be more invariant in their feature-specific directions of invariance, which is exactly the kind of property that motivates the use of deeper architectures.

## 6 Conclusion

In this paper, we attempt to answer the following question: what makes a good representation?. Besides being useful for a particular task, which we can measure, or towards which we can train a representation, this paper highlights the advantages for representations to be *locally invariant in many directions* of change of the raw input. This idea is implemented by a penalty on the Frobenius norm of the Jacobian matrix of the encoder mapping, which computes the