dimension (hence forming a bottleneck), it has been shown that the learnt parameters of the encoder are a subspace of the principal components of the input space Baldi and Hornik (1989). With the use of non-linear activation functions an AE can however be expected to learn more useful feature-detectors than what can be obtained with a simple PCA (Japkowicz *et al.*, 2000). Moreover, contrary to their classical use as dimensionality-reduction techniques, in their modern instantiation auto-encoders are often employed in a so-called *over-complete* setting to extract a number of features larger than the input dimension, yielding a rich higher-dimensional representation. In this setup, using some form of regularization becomes essential to avoid uninteresting solutions where the auto-encoder could perfectly reconstruct the input without needing to extract any useful feature. This section formally defines the auto-encoder variants considered in this study.

Basic auto-encoder (AE). The encoder is a function f that maps an input x ∈ IRdxto hidden representation h(x) ∈ IRdh. It has the form

$$h=f(x)=s_{f}(W x+b_{h}),$$
$$(2)$$
$$+\,b_{y}),$$
h = f(x) = sf (W x + bh), (2)
where sf is a nonlinear *activation function*, typically a logistic sigmoid(z) =
1 1+e−z . The encoder is parametrized by a dh × dx weight matrix W, and a bias vector bh ∈ IRdh.

The decoder function g maps hidden representation h back to a reconstruction y:
y = g(h) = sg(W0h + by), (3)
where sg is the decoder's activation function, typically either the identity (yielding linear reconstruction) or a sigmoid. The decoder's parameters are a bias vector by ∈ IRdx, and matrix W0. In this paper we only explore the tied weights case, in which W0 = WT.

Auto-encoder training consists in finding parameters θ = {W, bh, by} that minimize the reconstruction error on a training set of examples Dn, which corresponds to minimizing the following objective function:

$${\mathcal{I}}_{\mathrm{AE}}(\theta)=\sum_{x\in D_{n}}L(x,g(f(x))),$$
$$\left({4}\right)$$

L(x, g(f(x))), (4)
where L is the reconstruction error. Typical choices include the squared error L(*x, y*) = kx−yk 2 used in cases of linear reconstruction and the cross-entropy loss when sg is the sigmoid (and inputs are in [0, 1]): L(*x, y*) = −Pdx i=1 xilog(yi)+
(1 − xi) log(1 − yi).

Regularized auto-encoders (AE+wd). The simplest form of regularization is *weight-decay* which favors small weights by optimizing instead the following regularized objective:

$${\mathcal{J}}_{\mathrm{AE+wd}}(\theta)=\left(\sum_{x\in D_{n}}L(x,g(f(x)))\right)+\lambda\sum_{i j}W_{i j}^{2},$$

where the λ hyper-parameter controls the strength of the regularization.

Note that rather than having a prior on what the weights should be, it is possible to have a prior on what the hidden unit activations should be. From

$$\left(5\right)$$
