# Algorithms And Complexity Results For Persuasive Argumentation ∗†

Eun Jung Kima, Sebastian Ordyniakb, Stefan Szeiderb a AlGCo project-team, CNRS, LIRMM, Montpellier, France b Vienna University of Technology, Vienna, Austria

## Abstract

The study of arguments as abstract entities and their interaction as introduced by Dung (*Artificial Intelligence* 177, 1995) has become one of the most active research branches within Artificial Intelligence and Reasoning.

A main issue for abstract argumentation systems is the selection of acceptable sets of arguments. Value-based argumentation, as introduced by Bench-Capon (*J. Logic Comput.* 13, 2003), extends Dung's framework. It takes into account the relative strength of arguments with respect to some ranking representing an audience: an argument is subjectively accepted if it is accepted with respect to some audience, it is objectively accepted if it is accepted with respect to all audiences.

Deciding whether an argument is subjectively or objectively accepted, respectively, are computationally intractable problems. In fact, the problems remain intractable under structural restrictions that render the main computational problems for non-value-based argumentation systems tractable. In this paper we identify nontrivial classes of value-based argumentation systems for which the acceptance problems are polynomial-time tractable. The classes are defined by means of structural restrictions in terms of the underlying graphical structure of the value-based system. Furthermore we show that the acceptance problems are intractable for two classes of value-based systems that where conjectured to be tractable by Dunne (*Artificial Intelligence* 171, 2007).

## 1 Introduction

The study of arguments as abstract entities and their interaction as introduced by Dung [12] has become one of the most active research branches within Artificial Intelligence and Reasoning, see, e.g., [3, 6, 24]. Argumentation handles possible conflicts between arguments in form of attacks. The arguments may either originate from a dialogue between several agents or from the pieces of information at the disposal of a single agent, this information may even contain contradictions. A main issue for any argumentation system is the selection of acceptable sets of arguments, where an acceptable set of arguments must be in some sense coherent and be able to defend itself against all attacking arguments. Abstract argumentation provides suitable concepts and formalisms to study, represent, and process various reasoning problems most prominently in defeasible reasoning (see, e.g., [23], [8]) and agent interaction (see, e.g., [22]).

Extending Dung's concept, Bench-Capon [4] introduced *value-based argumentation* systems that allow to compare arguments with respect to their relative strength such that an argument cannot successfully attack another argument that is considered of a higher rank. The ranking is specified by the combination of an assignment of values to arguments and an ordering of the values; the latter is called an *audience* [5]. As laid out by BenchCapon, the role of arguments in this setting is to persuade rather than to prove, demonstrate or refute. Whether an argument can be accepted with respect to all possible or *at least one* audience allows to formalize the notions of *objective acceptance* and *subjective acceptance*, respectively.

∗Ordyniak and Szeider's research was supported by the European Research Council, grant reference 239962. Kim's research was partially supported by the EPSRC, grant reference EP/E034985/1.

†A preliminary and shortened version of this paper appeared in COMMA 2010.

arXiv:1104.4290v1 [cs.AI] 21 Apr 2011