Task B. To construct formulas ϕs and ϕo in MSO logic such that for every value-based system F and every argument x1 of F it holds that ϕs is true for S[**F, x**1] if and only if x1 is subjectively accepted in F, and ϕo is true for S[**F, x**1] if and only if x1 is objectively accepted in F.

## 4.2 Reference Graphs

For many problems it is rather straight-forward to find an MSO formulation so that Courcelle's Theorem can be applied. In our case, however, we have to face the difficulty that we have to express that "a certain property holds for some total ordering" (subjective acceptance) and "a certain property holds for all total orderings" (objective acceptance), which cannot be directly expressed in MSO. Our solution to this problem lies in the introduction of an auxiliary directed graph R, the *reference graph*, which will allow us to quantify over total orderings of V . The relational structure S[**F, x**1] will then be defined to represent F together with R.

Definition 12. Let F = (**X, A, V, η**) be a value-based system and let ≺ *be an arbitrary but fixed total ordering* of V *. The* reference graph R = (**V, E**R) is the directed graph where V is the set of values of F and ER *consists* of all directed edges (**u, v**) *for which* 1. u ≺ v *in the fixed ordering, and* 2. A *contains an attack* (**x, x**′) *with* η(x) = u and η(x
′) = v or η(x) = v and η(x
′) = u.

For a subset Q ⊆ ER let R[Q] = (**V, E**R[Q]) be the directed graph obtained from the reference graph R by reversing all edges in Q*, i.e.,* ER[Q] := { (u, v) | (u, v) ∈ ER \ Q) } ∪ { (v, u) | (**u, v**) ∈ ER ∩ Q }.

We also define the abstract argumentation system F[Q] := (**X, A**[Q]) as the system obtained from F *with* A[Q] := { (u, v) ∈ A | (η(u), η(v)) ∈/ ER[Q]) }.

Note that the reference graph R is by definition acyclic (in contrast to the value graph Gval F whose definition is similar but distinct).

Every specific audience ≤ of F can now be represented by some subset Q ⊆ ER for which the directed graph R[Q] is acyclic, and conversely, every set Q ⊆ ER such that R[Q] is acyclic represents a specific audience ≤.

These observations are made precise in the following lemma whose easy proof is omitted.

Lemma 6. An argument x1 is subjectively accepted in F if and only if there exists a set Q ⊆ ER *such that* R[Q]
is acyclic and x1 is in the unique preferred extension of F[Q]. An argument x1 is objectively accepted in F if and only if for every set Q ⊆ ER such that R[Q] is acyclic it holds that x1 *is in the unique preferred extension of* F[Q].

Since we can test for acyclicity with MSO logic (see the next subsection), we can now express subjective and objective acceptance in MSO logic as "a certain property holds for some subset Q of ER for which R[Q] is acyclic" and "a certain property holds for all subsets Q of ER for which R[Q] is acyclic", respectively. Next we give a more detailed description of how to accomplish the two tasks for our proof.

## 4.3 Task A: Representing The Value-Based System

We define a relational structure S[**F, x**1] that represents the value-based system F together with the reference graph R = (**V, E**R). The universe of S[**F, x**1] is the union of the sets X, V , and ER. S[**F, x**1] has one unary relation U
∗
a and four binary relations H, T , Ba and Bη that are defined as follows:
1. U∗a(x) if and only if x = x1 (used to "mark" the query argument).

2. T(t,(**u, v**)) if and only if t = u (used to represent the "tail relation" of ER)
3. H(h,(**u, v**)) if and only if h = v (used to represent the "head relation" of ER) 4. Ba(**x, y**) if and only if (**x, y**) ∈ A (used to represent the attack relation).

5. Bη(**x, v**) if and only if η(x) = v (used to represent the mapping η).