An important limitation for using value-based argumentation systems in real-world applications is the *computational intractability* of the two basic acceptance problems: deciding whether a given argument is subjectively accepted is NP-hard, deciding whether it is objectively accepted is co-NP-hard [15]. Therefore it is important to identify classes of value-based systems that are still useful and expressible but allow a polynomial-time tractable acceptance decision. However, no non-trivial tractable classes of value-based systems have been identified so far, except for systems with a tree structure where the degree of nodes and the number of nodes of degree exceeding 2 are bounded [14]. In fact, as pointed out by Dunne [13], the acceptance problems remain intractable for valuebased systems whose graphical structures form trees, in strong contrast to the main computational problems for non-value-based argumentation that are linear-time tractable for tree systems, or more generally, for systems of bounded treewidth [13] .

Our Contribution In this paper we introduce nontrivial classes of value-based systems for which the acceptance problems are tractable. The classes are defined in terms of the following notions:
- The *value-width* of a value-based system is the largest number of arguments of the same value.

- The *extended graph structure* of a value-based system has as nodes the arguments of the value-based system, two arguments are joined by an edge if either one attacks the other or both share the same value.

- The *value graph* of a value-based system has as vertices the values of the system, two values v1 and v2 are joined by a directed edge if some argument of value v1 attacks an argument of value v2 [14].

We show that the acceptance problems are tractable for the following classes of value-based systems:
(P1) value-based systems with a bipartite graph structure where at most two arguments share the same value
(i.e., systems of value-width 2);
(P2) value-based systems whose extended graph structure has bounded treewidth; and
(P3) value-based systems of bounded value-width whose value graphs have bounded treewidth.

In fact, we show that both acceptance problems are *linear time tractable* for the classes (P2) and (P3), the latter being a subclass of the former. Our results suggest that the extended graph structure is a suitable structural representation of value-based argumentation systems. The positive results (P1)–(P3) hold for systems with unbounded number of arguments, attacks and values.

We contrast our positive results with negative results that rule out classes conjectured to be tractable. We show that the acceptance problems are (co)-NP-hard for the following classes:
(N1) value-based systems of value-width 2;

(N2) value-based systems where the number of attacks between arguments of the same value is bounded (systems of *bounded attack-width*);
(N3) value-based systems with bipartite value graphs.

In fact, we show that both acceptance problems are intractable for value-based systems of value-width 2 and attack-width 1. Classes (N1) and (N2) were conjectured to be tractable [13], the complexity of (N3) was stated as an open problem [14].

The reminder of the paper is organized as follows. In Section 2 we provide basic definitions and preliminaries. In Section 3 we define the parameters value-width and attack-width and establish the results involving systems of value-width 2, we also discuss the relationship between systems of value-width 2 and dialogues [5]. In Section 4 we consider value-based systems with an extended graph structure of bounded treewidth and show linear time tractability. We close in Section 5 with concluding remarks. Some proofs of technical lemmas are given in an appendix.

The main results of this paper have been presented in preliminary and shortened form at COMMA'10 [21].

Here we provide full proofs, examples, and additional discussions. Further new additions are the results (P3) and (N3) involving value graphs, and the discussion of the relationship between systems of value-width 2 and dialogues.