
## 2 Arguments, Attacks, Values, And Audiences

In this section we introduce the objects of our study more formally.

## 2.1 Abstract Argumentation System

Definition 1. An abstract argumentation system or argumentation framework *is a pair* (**X, A**) where X *is a finite* set of elements called arguments and A ⊆ X × X *is a binary relation called the* attack relation*. If* (**x, y**) ∈ A we say that x attacks y.

An abstract argumentation system F = (**X, A**) can be considered as a directed graph, and therefore it is convenient to borrow notions and notation from the theory of directed graphs [1]. For example we say that a system F = (**X, A**) is *acyclic* if (**X, A**) is a DAG (a directed acyclic graph).

Example 1. An abstract argumentation system F0 = (**X, A**) with arguments X = {a, b, c, d, e, f} and attacks A = {(a, d), (a, e), (b, a), (c, d), (d, b), (**f, c**)} is displayed in Figure 1.

![0_image_1.png](0_image_1.png)

![0_image_0.png](0_image_0.png)

Figure 1: The abstract argumentation system F0 and value-based system F of Examples 1 and 2, respectively.

Next we define commonly used semantics of abstract argumentation systems as introduced by Dung [12]. For the discussion of other semantics and variants, see, e.g., Baroni and Giacomin's survey [2]. Let F = (**X, A**) be an abstract argumentation system and S ⊆ X.

1. S is *conflict-free* in F if there is no (**x, y**) ∈ A with **x, y** ∈ S.

2. S is *acceptable* in F if for each x ∈ S and each y ∈ X with (**y, x**) ∈ A there is some x
′ ∈ S with
(x
′, y) ∈ A.

3. S is *admissible* in F if it is conflict-free and acceptable.

4. S is a *preferred extension* of F if S is admissible in F and there is no admissible set S
′ of F that properly contains S.
For instance, the admissible sets of the abstract argumentation system F0 of Example 1 are the sets ∅ and {f},
hence {f} is its only preferred extension.

Let F = (**X, A**) be an abstract argumentation system and x1 ∈ X. The argument x1 is *credulously accepted* in F if x1 is contained in some preferred extension of F, and x1 is *skeptically accepted* in F if x1 is contained in all preferred extensions of F.

In this paper we are especially interested in finding preferred extensions in *acyclic* abstract argumentation systems. It is well known that every acyclic system F = (**X, A**) has a unique preferred extension GE(F), and that GE(F) can be found in polynomial time (GE(F) coincides with the "grounded extension" [12]). In fact, GE(F) can be found via a simple labeling procedure that repeatedly applies the following two rules to the arguments in X until each of them is either labeled IN or OUT: