1. An argument x is labeled IN if all arguments that attack x are labeled OUT (in particular, if x is not attacked by any argument).

2. An argument x is labeled OUT if it is attacked by some argument that is labeled IN.
The unique preferred extension GE(F) is then the set of all arguments that are labeled IN.

## 2.2 Value-Based Systems

Definition 2. A value-based argumentation framework or value-based system *is a tuple* F = (**X, A, V, η**) *where* (**X, A**) is an argumentation framework, V *is a set of* values, and η is a mapping X → V *such that the abstract* argumentation system Fv = (η
−1(v), { (x, y) ∈ A | **x, y** ∈ η
−1(v) }) *is acyclic for all* v ∈ V .

We call two arguments **x, y** ∈ X *to be* equivalued (in F*) if* η(x) = η(y).

The requirement for Fv to be acyclic is also known as the *Multivalued Cycles Assumption*, as it implies that any set of arguments that form a directed cycle in F = (**X, A**) will contain at least two arguments that are not equivalued [4].

Definition 3. An audience for a value-based system F is a partial ordering ≤ on the set V of values of F*. An* audience ≤ is specific *if it is a total ordering on* V .

For an audience ≤ we also define < in the obvious way, i.e., **x < y** if and only if x ≤ y and x 6= y.

Definition 4. *Given a value-based system* F = (**X, A, V, η**) and an audience ≤ for F*, we define the abstract* argumentation system induced by ≤ from F as F≤ = (**X, A**≤) *with* A≤ = { (x, y) ∈ A | ¬(η(x) < η(y)) }.

Note that if ≤ is a specific audience, then F≤ = (**X, A**≤) is an acyclic system and thus, as discussed above, has a unique preferred extension GE(F≤).

Example 2. Consider the value-based system F = (**X, A, V, η**) obtained from the abstract argumentation framework F0 of Example 1 by adding the set of values V = {**S, E, T** } and the mapping η with η(a) = η(b) = S,
η(c) = η(d) = E, η(e) = η(f) = T . The value-based system F is depicted in Figure 1 where the three ellipses indicate arguments that share the same value.

Definition 5. Let F = (**X, A, V, η**) *be a value-based system. We say that an argument* x1 ∈ X is subjectively accepted in F if there exists a specific audience ≤ such that x1 *is in the unique preferred extension of* F≤. Similarly, we say that an argument x1 ∈ X is objectively accepted in F if x1 is contained in the unique preferred extension of F≤ *for every specific audience* ≤.

Example 3. Consider our running example, the value-based system F given in Example 2. Suppose F represents the interaction of arguments regarding a city development project, and assume the arguments **a, b** are related to sustainability issues (S), the arguments **c, d** are related to economics (E), and the arguments **e, f** are related to traffic issues (T ).

Now, consider the specific audience ≤ that gives highest priority to sustainability, medium priority to economics, and lowest priority to traffic (**S > E > T** ). This audience gives rise to the acyclic abstract argumentation system F≤ obtained from F by deleting the attack (**d, b**) (as η(b) = **S > E** = η(d), d cannot attack b with respect to the audience) and deleting the attack (**f, c**) (as η(c) = **E > T** = η(f), f cannot attack c with respect to the audience).

Figure 2 exhibits the acyclic abstract argumentation systems induced by the six possible specific audiences.

The unique preferred extension for each of the six systems is indicated by shaded nodes. We conclude that all arguments of F are subjectively accepted, and **e, f** are the arguments that are objectively accepted.