
## 3.1 Certifying Paths

The key to the proofs of Theorems 1 and 2 is the notion of a "certifying path" which defines a certain path-like substructure within a value-based system. We show that in value-based systems of value-width 2, the problems of SUBJECTIVE and OBJECTIVE ACCEPTANCE can be expressed in terms of certifying paths. We then show that in general finding a certifying path in a value-based system of value-width 2 is NP-hard (3SAT can be expressed in terms of certifying paths) but is easy if the system is bipartite.

Definition 9. Let F = (**X, A, V, η**) be a value-based system of value-width 2*. We call an odd-length sequence* C = (x1, z1, . . . , xk, zk, t), k ≥ 0*, of distinct arguments a* certifying path for x1 ∈ X in F *if it satisfies the* following conditions:
C1 For every 1 ≤ i ≤ k *it holds that* η(zi) = η(xi).

C2 For every 1 ≤ i ≤ k there exists a 1 ≤ j ≤ i such that zi attacks xj .

C3 For every 2 ≤ i ≤ k it holds that xi attacks zi−1 but xi *does not attack any argument in* {zi, x1**, . . . , x**i−1}.

C4 Argument t attacks zk *but it does not attack any argument in* {x1**, . . . , x**k}.

C5 If there exists an argument z ∈ X \ {t} *with* η(z) = η(t) then either t attacks z or z does not attack any argument in {x1, . . . , xk, t}.
Lemma 1. Let F = (**X, A, V, η**) be a value-based system of value-width 2 and x1 ∈ X. Then x1 *is subjectively* accepted in F *if and only if there exists a certifying path for* x1 in F.

The rather technical proof of this lemma is given in the appendix. We discuss the intuition behind the concept of certifying paths by means of an example.

Example 4. Consider the value-based system F of Example 2. We want to check whether argument a is subjectively accepted, i.e., to identify a specific audience ≤ such that a is in the unique preferred extension GE(F≤)
of F≤. Since a is attacked by b and we cannot eliminate this attack (a and b are equivalued), we need to defend a by attacking b. The only possibility for that is to attack b by d. Hence we need to put **S < E** in our audience. However, since d is attacked by the equivalued argument c, we need to defend it by attacking c by f, hence we need to put **S < E < T** . Since f is not attacked by any other argument we can stop. Via this process we have produced a certifying path Ca = (**a, b, d, c, f**), and we can check that Ca indeed satisfies Definition 9. For the other subjectively accepted arguments of F we have the certifying paths Cb = (b), Cc = (c), Cd = (**d, c, f**), Ce = (e) and Cf = (f).

In order to use the concept of certifying paths for objective acceptance, we need the following definition.

Definition 10. Let F = (**X, A, V, η**) be a value-based system and v ∈ V a value. We denote by F − v the valuebased system obtained from F by deleting all arguments with value v *and all attacks involving these arguments.*
Lemma 2. Let F = (**X, A, V, η**) be a value-based system of value-width 2 and x1 ∈ X. Then x1 *is objectively* accepted in F if and only if for every argument p ∈ X that attacks x1 it holds that η(p) 6= η(x1) and p is not subjectively accepted in F − η(x1).

Again, the technical proof is moved to the appendix.

Example 5. In our example, consider the argument e. We want to check whether e is objectively accepted. Since e is only attacked by a, and since η(a) 6= η(e), it remains to check whether a is not subjectively accepted in F − η(e). In fact, F − η(e) contains no certifying path for a. Hence e is objectively accepted in F.

7