contrast, if the pick-up action's effects are stochastic, then trying the same picking action multiple times increases the chances of success.

Garland & Lesh (2002) share the same objective with us on generating robust plans under incomplete domain models. However, their notion of robustness, which is defined in terms of four different types of risks, only has tenuous heuristic connections with the likelihood of successful execution of plans. Robertson & Bryce (2009) focuses on the plan generation in Garland & Lesh model, but their approach still relies on the same unsatisfactory formulation of robustness. The work by Fox et al (2006) also explores robustness of plans, but their focus is on temporal plans under unforeseen execution-time variations rather than on incompletely specified domains. Our work can also be categorized as one particular instance of the general model-lite planning problem, as defined in (Kambhampati 2007), in which the author points out a large class of applications where handling incomplete models is unavoidable due to the difficulty in getting a complete model.

## 3. Problem Formulation

We define an *incomplete domain model* De as De = h**F, A**i, where F = {p1, p2**, ..., p**n} is a set of *propositions*, A is a set of *actions* that might be incompletely specified. We denote T and F as the *true* and *false* truth values of propositions.

A *state* s ⊆ F is a set of propositions. In addition to proposition sets that are known as its preconditions **P re**(a) ⊆ F,
add effects Add(a) ⊆ F and delete effects Del(a) ⊆ F, each action a ∈ A also contains:
- Possible precondition set **P re** g(a) ⊆ F contains propositions that action a *might* need as its preconditions.

- Possible add (delete) effect set Add g(a) ⊆ F (Del g(a) ⊆
F) contains propositions that the action a *might* add
(delete, respectively) after its execution.

In addition, each possible precondition, add and delete effect p of the action a is associated with a weight w pre a(p),
w add a(p) and w del a(p) (0 < wpre a(p), wadd a(p), wdel a(p) < 1)
representing the domain modeler's assessment of the likelihood that p will actually be *realized* as a precondition, add and delete effect of a (respectively) during plan execution.

Possible preconditions and effects whose likelihood of realization is not given are assumed to have weights of 12
.

Given an incomplete domain model De, we define its completion set **hhDii** e as the set of *complete* domain models whose actions have all the necessary preconditions, adds and deletes, and a *subset* of the possible preconditions, possible adds and possible deletes. Since any subset of P re g(a), Add g(a) and Del g(a) can be realized as preconditions and effects of action a, there are exponentially large number of possible *complete* domain models Di ∈
hhDii e = {D1, D2**, ...,** D2K }, where K =
Pa∈A
(|**P re** g(a)| +
|Add g(a)| + |Del g(a)|). For each complete model Di, we denote the corresponding sets of realized preconditions and effects for each action a as P rei(a), Addi(a) and Deli(a);
equivalently, its complete sets of preconditions and effects are P re(a) ∪ P rei(a), Add(a) ∪ Addi(a) and Del(a) ∪
Deli(a).

The projection of a sequence of actions π from an initial state I according to an incomplete domain model De is defined in terms of the projections of π from I according to each complete domain model Di **∈ hhDii** e :

$$\gamma(\pi,I,\tilde{D})=\bigcup\gamma(\pi,I,D_{i})\tag{1}$$

where the projection over complete models is defined in the usual STRIPS way, with one important difference. The result of applying an action a in a state s where the preconditions of a are not satisfied is taken to be s (rather than as an undefined state).1 A *planning problem with incomplete domain* is Pe =
hDe**, I, G**i where I ⊆ F is the set of propositions that are true in the *initial state*, and G is the set of *goal propositions*. An action sequence π is considered a **valid plan** for Pe if π solves the problem in at least one completion of **hhDii** e .

Specifically, ∃Di∈hhDii e γ(**π, I,** Di) |= G.

Modeling Issues in Annotating Incompleteness: From the modeling point of view, the possible precondition and effect sets can be modeled at either the grounded action or action schema level (and thus applicable to all grounded actions sharing the same action schema). From a practical point of view, however, incompleteness annotations at ground level hugely increase the burden on the domain modeler. To offer a flexible way in modeling the domain incompleteness, we allow annotations that are restricted to either specific variables or value assignment to variables of an action schema.

In particular:
- *Restriction on value assignment to variables*: Given variables xi with domains Xi, one can indicate that p(xi1**, ..., x**ik
) is a possible precondition/effect of an action schema a(x1**, ..., x**n) when some variables xj1**, ..., x**jlhave values cj1 ∈ Xj1**, ..., c**jl ∈ Xjl
({i1, ..., ik}, {j1, ..., jl} ⊆ {1**, ..., n**}). Those possible preconditions/effects can be specified with the annotation p(xi1**, ..., x**ik
) : when (xj1 = c1 ∧ ... ∧ xjl = cl) for the action schema a(x1**, ..., x**n). More generally, we allow the domain writer to express a constraint C on the variables xj1**, ..., x**jl in the : **when** construct. The annotation p(xi1**, ..., x**ik
) : **when** (C) means that p(ci1**, ..., c**ik
)
is a possible precondition/effect of an instantiated action a(c1**, ..., c**n) (ci ∈ Xi) if and only if the assignment
(xj1:= cj1**, ..., x**jl
:= cjl

) satisfies the constraint C. This syntax subsumes both the annotations at the ground level when l = n, and at the schema level if l = 0 (or the
: **when** construct is not specified).

- *Restriction on variables*: Instead of constraints on explicit values of variables, we also allow the possible preconditions/effects p(xi1**, ..., x**ik
) of an action schema 1We shall see that this change is necessary so that we can talk about increasing the robustness of a plan by adding additional actions.