in which we randomly introduce incompleteness into IPC domains, and discuss the feasibility of our approach in this setting.3

## Domains With Deliberate Incompleteness

Logistics: In this domain, each of the two cities C1 and C2 has an airport and a downtown area. The transportation between the two distant cities can only be done by two airplanes A1 and A2. In the downtown area of Ci (i ∈ {1, 2}), there are three *heavy* containers Pi1**, ..., P**i3 that can be moved to the airport by a truck Ti. Loading those containers onto the truck in the city Ci, however, requires moving a team of m robots Ri1**, ..., R**im (m ≥ 1), initially located in the airport, to the downtown area. The source of incompleteness in this domain comes from the assumption that each pair of robots R1j and R2j (1 ≤ j ≤ m) are made by the same manufacturer Mj , both therefore might fail to load a *heavy* container.4 The actions loading containers onto trucks using robots made by a particular manufacturer (e.g., the action schema *load-truck-with-robots-of-M1* using robots of manufacturer M1), therefore, have a possible precondition requiring that containers should not be heavy. To simplify discussion (see below), we assume that robots of different manufacturers may fail to load heavy containers, though independently, with the same probability of 0.7.

The goal is to transport all three containers in the city C1 to C2, and vice versa. For this domain, a plan to ship a container to another city involves a step of loading it onto the truck, which can be done by a robot (after moving it from the airport to the downtown). Plans can be made more robust by using additional robots of *different* manufacturer after moving them into the downtown areas, with the cost of increasing plan length.

Satellite: In this domain, there are two satellites S1 and S2 orbiting the planet Earth, on each of which there are m instruments Li1, ..., Lim (i ∈ {1, 2}, m ≥ 1) used to take images of interested modes at some direction in the space. For each j ∈ {1**, ..., m**}, the lenses of instruments Lij 's were made from a type of material Mj, which might have an error affecting the quality of images that they take. If the material Mj actually has error, all instruments Lij 's produce mangled images. The knowledge of this incompleteness is modeled as a *possible add effect* of the action taking images using instruments made from Mj (for instance, the action schema *take-image-with-instruments-M1* using instruments of type M1) with a probability of pj , asserting that images taken might be in a bad condition. A typical plan to take an image using an instrument, e.g. L14 of type M4 on the satellite S1, is first to switch on L14, turning the satellite S1 to a ground direction from which L14 can be calibrated, and then taking image. Plans can be made more robust by using additional instruments, which might be on a different satel3The experiments were conducted using an Intel Core2 Duo 3.16GHz machine with 4Gb of RAM, and the time limit is 15 minutes.

4The *uncorrelated incompleteness* assumption applies for possible preconditions of action schemas specified for different manufacturers. It should not be confused here that robots R1j and R2j of the same manufacturer Mj can independently have fault.

ρ m = 1 m = 2 m = 3 m = 4 m = 5

0.1 32/10.9 36/26.2 40/57.8 44/121.8 48/245.6 0.2 32/10.9 36/25.9 40/57.8 44/121.8 48/245.6 0.3 32/10.9 36/26.2 40/57.7 44/122.2 48/245.6 0.4 ⊥ 42/42.1 50/107.9 58/252.8 66/551.4

0.5 ⊥ 42/42.0 50/107.9 58/253.1 66/551.1

0.6 ⊥ ⊥ 50/108.2 58/252.8 66/551.1 0.7 ⊥ ⊥ ⊥ 58/253.1 66/551.6 0.8 ⊥ ⊥ ⊥ ⊥ 66/550.9

0.9 ⊥ ⊥ ⊥ ⊥ ⊥

Table 1: The results of generating robust plans in Logistics domain (see text). Table 2: The results of generating robust plans in Satellite domain (see text). lite, but should be of *different* type of materials and can also take an image of the interested mode at the same direction.

Table 1 and 2 shows respectively the results in the Logistics and Satellite domains with ρ ∈ {0.1, 0.2**, ...,** 0.9} and m = {1, 2**, ...,** 5}. The number of complete domain models in the two domains is 2 m. For Satellite domain, the probabilities pj 's range from 0.25, 0.3,... to 0.45 when m increases from 1, 2, ... to 5. For each specific value of ρ and m, we report l/t where l is the length of plan and t is the running time (in seconds). Cases in which no plan is found within the time limit are denoted by "–", and those where it is provable that no plan with the desired robustness exists are denoted by "⊥".

Observations on fixed value of m: In both domains, for a fixed value of m we observe that the solution plans tend to be longer with higher robustness threshold ρ, and the time to synthesize plans is also larger. For instance, in Logistics with m = 5, the plan returned has 48 actions if ρ = 0.3, whereas 66-length plan is needed if ρ increases to 0.4. Since loading containers using the same robot multiple times does not increase the chance of success, more robots of different manufacturers need to move into the downtown area for loading containers, which causes an increase in plan length.

In the Satellite domain with m = 3, similarly, the returned plan has 37 actions when ρ = 0.5, but requires 53 actions if ρ = 0.6—more actions need to calibrate an instrument of different material types in order to increase the chance of having a good image of interested mode at the same direction.

Since the cost of actions is currently ignored in the compilation approach, we also observe that more than the needed number of actions have been used in many solution plans. In

| ρ   | m = 1   | m = 2   | m = 3    | m = 4    | m = 5    |
|-----|---------|---------|----------|----------|----------|
| 0.1 | 10/0.1  | 10/0.1  | 10/0.2   | 10/0.2   | 10/0.2   |
| 0.2 | 10/0.1  | 10/0.1  | 10/0.1   | 10/0.2   | 10/0.2   |
| 0.3 | ⊥       | 10/0.1  | 10/0.1   | 10/0.2   | 10/0.2   |
| 0.4 | ⊥       | 37/17.7 | 37/25.1  | 10/0.2   | 10/0.3   |
| 0.5 | ⊥       | ⊥       | 37/25.5  | 37/79.2  | 37/199.2 |
| 0.6 | ⊥       | ⊥       | 53/216.7 | 37/94.1  | 37/216.7 |
| 0.7 | ⊥       | ⊥       | ⊥        | 53/462.0 | -        |
| 0.8 | ⊥       | ⊥       | ⊥        | ⊥        | -        |
| 0.9 | ⊥       | ⊥       | ⊥        | ⊥        | ⊥        |
