the Logistics domain, specifically, it is easy to see that the probability of successfully loading a container onto a truck using robots of k (1 ≤ k ≤ m) different manufacturers is
(1 − 0.7 k). As an example, however, robots of all five manufacturers are used in a plan when ρ = 0.4, whereas using those of three manufacturers is enough.

Observations on fixed value of ρ: In both domains, we observe that the maximal robustness value of plans that can be returned increases with higher number of manufacturers
(though the higher the value of m is, the higher number of complete models is). For instance, when m = 2 there is not any plan returned with at least ρ = 0.6 in the Logistics domain, and with ρ = 0.4 in the Satellite domain. Intuitively, more robots of different manufacturers offer higher probability of successfully loading a container in the Logistics domain (and similarly for instruments of different materials in the Satellite domain).

Finally, it may take longer time to synthesize plans with the same length when m is higher—in other words, the increasing amount of incompleteness of the domain makes the plan generation phase harder. As an example, in the Satellite domain, with ρ = 0.6 it takes 216.7 seconds to synthesize a 37-length plan when there are m = 5 possible add effects at the schema level of the domain, whereas the search time is only 94.1 seconds when m = 4. With ρ = 0.7, no plan is found within the time limit when m = 5, although a plan with robustness of 0.7075 exists in the solution space. It is the increase of the branching factors and the time spent on satisfiability test and weighted model-counting used inside the planner that affect the search efficiency.

## Domains With Random Incompleteness

We built a program to generate an incomplete domain model from a deterministic one by introducing M new propositions into each domain (all are initially T). Some of those new propositions were randomly added into the sets of *possible* preconditions/effects of actions. Some of them were also randomly made *certain* add/delete effects of actions. With this strategy, each solution plan in an original deterministic domain is also a *valid plan*, as defined earlier, in the corresponding incomplete domain. Our experiments with the Depots, Driverlog, Satellite and ZenoTravel domains indicate that because the annotations are random, there are often fewer opportunities for the PFF planner to increase the robustness of a plan prefix during the search. This makes it hard to generate plans with a desired level of robustness under given time constraint.

In summary, our experiments on the two settings above suggest that the compilation approach based on the PFF
planner would be a reasonable method for generating robust plans in domains and problems where there are chances for robustifying existing action sequences in the search space.

## 7. Conclusion And Future Work

In this paper, we motivated the need for synthesizing robust plans under incomplete domain models. We introduced annotations for expressing domain incompleteness, formalized the notion of plan robustness, and showed an approach to compile the problem of generating robust plans into conformant probabilistic planning. We presented empirical results showing the promise of our approach. For future work, we are developing a planning approach that directly takes the incompleteness annotations into account during the search, and compare it with our current compilation method. We also plan to consider the problem of robustifying a given plan subject to a provided cost bound. Acknowledgement: This research is supported in part by ONR grants N00014-09-1-0017 and N00014-07-1-1049, the NSF grant IIS-0905672, and by DARPA and the U.S. Army Research Laboratory under contract W911NF-11-C-0037.

The content of the information does not necessarily reflect the position or the policy of the Government, and no official endorsement should be inferred. We thank William Cushing for several helpful discussions.

## References

[Bryce, Kambhampati, and Smith 2006] Bryce, D.; Kambhampati, S.; and Smith, D. 2006. Sequential monte carlo in probabilistic planning reachability heuristics. *Proceedings of ICAPS06*.

[Domshlak and Hoffmann 2007] Domshlak, C., and Hoffmann, J. 2007. Probabilistic planning via heuristic forward search and weighted model counting. *JAIR* 30(1):565–620.

[Fox, Howey, and Long 2006] Fox, M.; Howey, R.; and Long, D. 2006. Exploration of the robustness of plans.

In *AAAI*.

[Garland and Lesh 2002] Garland, A., and Lesh, N. 2002.

Plan evaluation with incomplete action descriptions. In AAAI.

[Hoffmann, Weber, and Kraft 2010] Hoffmann, J.; Weber, I.; and Kraft, F. 2010. SAP Speaks PDDL. AAAI.

[Hyafil and Bacchus 2003] Hyafil, N., and Bacchus, F.

2003. Conformant probabilistic planning via CSPs. In Proceedings of the Thirteenth International Conference on Automated Planning and Scheduling, 205–214.

[Jensen, Veloso, and Bryant 2004] Jensen, R.; Veloso, M.;
and Bryant, R. 2004. Fault tolerant planning: Toward probabilistic uncertainty models in symbolic non-deterministic planning. In *ICAPS*.

[Kambhampati 2007] Kambhampati, S. 2007. Model-lite planning for the web age masses: The challenges of planning with incomplete and evolving domain theories. In AAAI.

[Kushmerick, Hanks, and Weld 1995] Kushmerick, N.;
Hanks, S.; and Weld, D. 1995. An algorithm for probabilistic planning. *Artificial Intelligence* 76(1-2):239–286.

[Robertson and Bryce 2009] Robertson, J., and Bryce, D.

2009. Reachability heuristics for planning in incomplete domains. In *ICAPS'09 Workshop on Heuristics for Domain* Independent Planning.