Example 11 *(Splitting the Cargo Import Knowledge Base*)
Consider the hybrid knowledge base K = hO,Pi presented in Fig. 1. One of the nontrivial splitting sequences for K is U = hU0, U1, U2, U3, Pi, where U0 = { Commodity/1, EdibleVegetable/1, Tomato/1, CherryTomato/1, GrapeTomato/1, HTSCode/2, HTSChapter/2, HTSHeading/2, Bulk/1, Prepackaged/1, TariffCharge/2, ShpmtCommod/2, ShpmtImporter/2, ShpmtDeclHTSCode/2, ShpmtProducer/2, ShpmtCountry/2 }
U1 = U0 ∪ { AdmissibleImporter/1, SuspectedBadGuy/1, ApprovedImporterOf/2 } U2 = U1 ∪ { RegisteredProducer/2, EUCountry/1, EURegisteredProducer/1, CommodCountry/2, ExpeditableImporter/2, LowRiskEUCommodity/1 }
U3 = U2 ∪ { CompliantShpmt/1, Random/1, RandomInspection/1, PartialInspection/1, FullInspection/1 } .

This splitting sequence splits K in four layers. The first layer contains all ontological knowledge regarding commodity types as well as information about shipments. The second layer contains rules that use information from the first layer together with internal records to classify importers. The third layer contains axioms with geographic classification, information about registered producers and, based on information about commodities and importers from the first two layers, it defines low risk commodities coming from the European Union. The final layer contains rules for deciding which shipments should be inspected based on information from previous layers.

## 3.2 Update Operator

With the concepts and results related to splitting hybrid knowledge bases from the previous subsection, we are now ready to examine the constraints under which a plausible modular update semantics for a hybrid knowledge base can be defined. Obviously, this is the case with hybrid knowledge bases that contain either only ontology axioms, or only rules. We call such knowledge bases *basic*, and define the dynamic MKNF model for basic dynamic knowledge bases by referring to the classical and rule update semantics defined in Sect. 2. Definition 12 *(Dynamic MKNF Model of a Basic Dynamic Hybrid Knowledge Base*)
We say a hybrid knowledge base K = hO,Pi is O*-based* if P contains only positive facts; P*-based* if O is empty; *basic* if it is either O-based or P-based. A dynamic hybrid knowledge base K = hKiii<n is O*-based* if for all **i < n**, Kiis O-based; P*-based* if for all **i < n**, Kiis P-based; *basic* if it is either O-based or P-based.

An MKNF interpretation M is a *dynamic MKNF model* of a basic dynamic hybrid knowledge base K = hKiii<n, where Ki = hOi,Pii, if either K is O-based and M is the minimal change update model of hζ (Oi) ∪ Piii<n, or K is P-based and M = { J **∈ I |** I ⊆ J } for some dynamic stable model I of hPiii<n.

As can be seen, our definition is slightly more general than described above, as in the case of O-based knowledge bases it allows the program part to contain positive facts. This amounts to the reasonable assumption that positive facts in a logic program carry the same meaning as the corresponding ground first-order atom. As will be seen in the following, this allows us to extend the class of basic hybrid knowledge bases and define dynamic MKNF models for it. To this end, we utilise the splitting-related concepts from the previous subsection. Their natural generalisation for dynamic hybrid knowledge bases follows.