Definition 13 *(Splitting Set and Splitting Sequence*)
A set of predicate symbols U is a splitting set for a dynamic hybrid knowledge base K =
hKiii<n if for all **i < n**, U is a splitting set for Ki.

The dynamic hybrid knowledge base hbU (Ki)ii<n is called the bottom of K *relative to* U and denoted by bU (K). The dynamic hybrid knowledge base htU (Ki)ii<n is called the top of K *relative to* U and denoted by tU (K). Given some X ∈ M, the dynamic hybrid knowledge base heU (Ki, X)ii<n is called the splitting set reduct of K relative to U and X
and denoted by eU (K, X).

A sequence of sets of predicate symbols U is a splitting sequence for K if for all **i < n**,
U is a splitting sequence for Ki.

In the static case, given a splitting set U, the splitting set theorem guarantees that an MKNF model M of a hybrid knowledge base K is an intersection of an MKNF model X
of bU (K) and of an MKNF model Y of eU (K, X). In the dynamic case, we can use this correspondence to *define* a dynamic MKNF model. More specifically, we can say that M is a dynamic MKNF model of a dynamic hybrid knowledge base K if M is an intersection of a dynamic MKNF model X of bU (K) and of a dynamic MKNF model Y of eU (K, X).

For the definition to be sound, we need to guarantee that X and Y are defined. In other words, K has to be such that both bU (K) and eU (K, X) are basic. When we move to the more general case of a splitting sequence U = hUαiα<µ, what we need to ensure is that bU0(K) is basic and for any ordinal α such that α + 1 < µ, eUα(bUα+1 (K),Tη<α Xη) is also basic. A class of dynamic hybrid knowledge bases that satisfies these conditions can be defined as follows: Definition 14 *(Updatable Dynamic Hybrid Knowledge Base*)
Let U be a set of predicate symbols. We say a hybrid knowledge base K is O-reducible relative to U if all rules r from P are positive and pr(B(r)) ⊆ U; P*-reducible relative to* U if O is empty; *reducible relative to* U if it is either O-reducible or P-reducible relative to U. A dynamic hybrid knowledge base K = hKiii<n is O*-reducible relative to* U if for all **i < n**, Kiis O-reducible relative to U; P*-reducible relative to* U if for all **i < n**, Kiis P-reducible relative to U; *reducible relative to* U if it is either O-reducible or P-reducible relative to U.

Let K be a (dynamic) hybrid knowledge base and U = hUαiα<µ be a splitting sequence for K. We say U is *update-enabling for* K if bU0(K) is reducible relative to ∅ and for any α such that α + 1 < µ, the hybrid knowledge base tUα(bUα+1 (K)) is reducible relative to Uα. We say K is *updatable* if some update-enabling splitting sequence for K exists.

The following proposition now guarantees the property of updatable dynamic hybrid knowledge bases that we discussed above.

Proposition 15 (*Layers of an Updatable Dynamic Hybrid Knowledge Base are Basic*)
Let U be an update-enabling splitting sequence for a dynamic hybrid knowledge base K
and X ∈ M. Then bU0(K) is a basic dynamic hybrid knowledge base and for any ordinal α such that α + 1 < µ, eUα(bUα+1 (K), X) is also a basic dynamic hybrid knowledge base.