be seen as some of the most expressive formalisms based on Classical Logic for which decidable reasoning procedures still exist.

On the other hand, nonmonotonic rules have also proven to be a very useful tool for knowledge representation. They complement the expressive power of DLs, adding the possibility to reason with incomplete information using default negation, and offering natural ways of expressing exceptions, integrity constraints and complex queries. Their formal underpinning lies with declarative, well-understood semantics, the stable model semantics
(Gelfond and Lifschitz 1988) and its tractable approximation, the well-founded semantics
(Gelder et al. 1991), being the most prominent and widely accepted.

This has led to the need to integrate these distinct knowledge representation paradigms.

Over the last decade, there have been many proposals for integrating DLs with nonmonotonic rules (see (Hitzler and Parsia 2009) for a survey). One of the more mature proposals is Hybrid MKNF Knowledge Bases (Motik and Rosati 2007) that allow predicates to be defined concurrently in both an ontology and a set of rules, while enjoying several important properties. A tractable variant of this formalism, based on the well-founded semantics, allows for a top-down querying procedure (Knorr et al. 2011), making the approach amenable to practical applications that need to deal with large knowledge bases.

While such formalisms make it possible to seamlessly combine rules and ontologies in a single unified framework, they do not take into account the highly dynamic character of application areas where they are to be used. In (Slota and Leite 2010b) we made a first step towards a solution to this problem, addressing *updates* by defining a change operation on a knowledge base to record a change that occurred in the modelled world.

Update operators have first been studied in the context of action theories and relational databases with NULL values (Winslett 1988; Winslett 1990). The basic intuition behind these operators is that the models of a knowledge base represent possible states of the world and when a change in the world needs to be recorded, each of these possible worlds should be modified as little as possible in order to arrive at a representation of the world after the update. This means that, in each possible world, each propositional atom retains its truth value as long as there is no update that directly requires it to change. In other words, *inertia* is applied to the atoms of the underlying language. Later, these operators were successfully applied to partially address updates of DL ontologies (Liu et al. 2006; Giacomo et al. 2006).

But when updates were studied in the context of rules, most authors found atom inertia unsatisfactory. One of the main reasons for this is the clash between atom inertia and the property of *support* (Apt et al. 1988; Dix 1995), which lies at the heart of most logic programming semantics. For instance, when updating a logic program P = { p ← **q., q.** }
by Q = { ∼q. },
1atom inertia dictates that p must stay true after the update because the update itself does not in any way directly affect the truth value of p. Example 7 in
(Giacomo et al. 2006), where a similar update is performed on an analogical DL ontology, shows that such a behaviour may be desirable. However, from a logic programming point of view, one expects p to become false after the update. This is because when q ceases being true, the reason for p to be true disappears as it is no longer supported by any rule.