These intuitions, together with a battery of intuitive examples (Leite and Pereira 1997; Alferes et al. 2000), led to the introduction of the *causal rejection principle* (Leite and Pereira 1997)
and subsequently to several approaches to rule updates (Alferes et al. 2000; Eiter et al. 2002; Leite 2003; Alferes et al. 2005) that are fundamentally different from classical update operators. The basic unit of information to which inertia is applied is no longer an atom, but a rule. This means that a rule stays in effect as long as it does not directly contradict a newer rule. The truth values of atoms are not directly subject to inertia, but are used to determine the set of rules that are overridden by newer rules, and are themselves determined by the remaining rules.

However, the dichotomy between classical and rule updates goes far beyond the different units of information to which inertia is applied. While classical updates are performed on the models of a knowledge base, which renders them syntax-independent, the property of support, being syntactic in its essence, forces rule update methods to refer to the syntactic structure of underlying programs - the individual rules they contain and, in many cases, also the heads and bodies of these rules. As we have shown in (Slota and Leite 2010a),
even when classical updates are applied to SE-models (Lifschitz et al. 2001; Turner 2003),
a monotonic semantics for logic programs that is more expressive than stable models, the property of support is lost. On the other hand, applying rule updates to DL ontologies leads to a range of technical difficulties. Some of them are caused by the fact that rule update methods are specifically tailored towards identifying and resolving conflicts between pairs of rules. DL axioms do not have a rule-like structure, and a group of pairwise consistent axioms may enter in a conflict. Other difficulties stem from the fact that such a syntactic approach can hardly exhibit behaviour similar to that of classical updates, where reasoning by cases is inherent in updating each model of a knowledge base independently of all others. Thus, no single method seems suitable for updating hybrid knowledge bases. A
general update operator for hybrid knowledge must somehow integrate these apparently irreconcilable approaches to dealing with evolving knowledge.

In (Slota and Leite 2010b) we simplified this hard task by keeping rules static and allowing the ontology component of a hybrid knowledge base to evolve. Despite the importance of this first step, the applicability of the operator is considerably diminished since typically all parts of a knowledge base are subject to change. As an example, consider the following scenario where both ontologies and rules are needed to assess the risk of imported cargo. Example 1 (*A Hybrid Knowledge Base for Cargo Imports*) The Customs service for any developed country assesses imported cargo for a variety of risk factors including terrorism, narcotics, food and consumer safety, pest infestation, tariff violations, and intellectual property rights.2 Assessing this risk, even at a preliminary level, involves extensive knowledge about commodities, business entities, trade patterns, government policies and trade agreements. Some of this knowledge may be external to a given customs agency: for instance the broad classification of commodities according to the international Harmonized Tariff System (HTS), or international trade agreements.

Other knowledge may be internal to a customs agency, such as lists of suspected violators or of importers who have a history of good compliance with regulations. While some of