this knowledge is relatively stable, much of it changes rapidly. Changes are made not only at a specific level, such as knowledge about the expected arrival date of a shipment; but at a more general level as well. For instance, while the broad HTS code for tomatoes (0702)
does not change, the full classification and tariffs for cherry tomatoes for import into the US changes seasonally.

Figure 1 shows a simplified fragment K = hO,Pi of such a knowledge base. In this fragment, a shipment has several attributes: the country of its origination, the commodity it contains, its importer, and its producer. The ontology contains a geographic classification, along with information about producers who are located in various countries. It also contains a classification of commodities based on their harmonised tariff information (HTS
chapters, headings and codes, cf. http://www.usitc.gov/tata/hts). Tariff information is also present, based on the classification of commodities. Finally, the ontology contains (partial) information about three shipments: s1, s2 and s3. There is also a set of rules indicating information about importers, and about whether to inspect a shipment either to check for compliance of tariff information or for food safety issues.

In this paper, we define an update semantics for hybrid knowledge bases that can be used to deal with scenarios such as the one described above. As a theoretical basis for this operator, we first establish a splitting theorem for Hybrid MKNF Knowledge Bases, analogical to the splitting theorem for logic programs (Lifschitz and Turner 1994). The underlying notions then serve us as theoretical ground for identifying a constrained class of hybrid knowledge bases for which a plausible update semantics can be defined by modularly combining a classical and a rule update operator. We then examine basic properties of this semantics, showing that it

- generalises Hybrid MKNF Knowledge Bases (Motik and Rosati 2007).

- generalises the classical minimal change update operator (Winslett 1990).

- generalises the refined dynamic stable model semantics (Alferes et al. 2005). - adheres to the principle of primacy of new information (Dalal 1988).
Finally, we demonstrate that it properly deals with nontrivial updates in scenarios such as the one described in Example 1.

The rest of this document is structured as follows: We introduce the necessary theoretical background in Sect. 2. Then, in Sect. 3, we establish the splitting theorem for Hybrid MKNF Knowledge Bases, identify a constrained class of such knowledge bases and define a plausible update operator for it. We also take a closer look at its properties and show how it can be applied to deal with updates of the knowledge base introduced in Example 1. We then discuss our results in Sect. 4 and point towards desirable future developments.3

## 2 Preliminaries

In this section we present the formal basis for our investigation. We introduce the unifying semantic framework of Hybrid MKNF Knowledge Bases (Motik and Rosati 2007) that