# Transition Systems For Model Generators - A Unifying Approach

YULIYA LIERLER and MIROSLAW TRUSZCZYNSKI
Department of Computer Science, University of Kentucky, Lexington, KY 40506-0633, USA
(*e-mail:* yuliya,mirek@cs.uky.edu)
submitted 1 January 2003; revised 1 January 2003; accepted 1 *January 2003*

## Abstract

A fundamental task for propositional logic is to compute models of propositional formulas. Programs developed for this task are called satisfiability solvers. We show that transition systems introduced by Nieuwenhuis, Oliveras, and Tinelli to model and analyze satisfiability solvers can be adapted for solvers developed for two other propositional formalisms: logic programming under the answerset semantics, and the logic PC(ID). We show that in each case the task of computing models can be seen as "satisfiability modulo answer-set programming," where the goal is to find a model of a theory that also is an answer set of a certain program. The unifying perspective we develop shows, in particular, that solvers CLASP and MINISAT(ID) are closely related despite being developed for different formalisms, one for answer-set programming and the latter for the logic PC(ID).

## 1 Introduction

A fundamental reasoning task for propositional logic is to compute models of propositional formulas or determine that no models exist. Programs developed for this task are commonly called model generators or satisfiability (SAT) solvers. In the paper we show that transition systems introduced by Nieuwenhuis et al. (2006) to model and analyze SAT solvers can be adapted for the analysis and comparison of solvers developed for other propositional formalisms. The two formalisms we focus on are logic programming with the answer-set semantics and the logic PC(ID).

Davis-Putnam-Logemann-Loveland (DPLL) procedure is a well-known method that exhaustively explores interpretations to generate models of a propositional formula. Most modern SAT solvers are based on variations of the DPLL procedure. Usually these variations are specified by pseudocode. Nieuwenhuis et al. (2006) proposed an alternative approach based on the notion of a transition system that describes "states of computation" and allowed transitions between them. In this way, it defines a directed graph such that every execution of the DPLL procedure corresponds to a path in the graph. This abstract way of presenting DPLL-based algorithms simplifies the analysis of their correctness and facilitates studies of their properties - instead of reasoning about pseudocode constructs, we reason about properties of a graph. For instance, by proving that the graph corresponding to a DPLL-based algorithm is finite and acyclic we show that the algorithm always terminates.

Answer-set programming (ASP) (Marek and Truszczy´nski 1999; Niemel¨a 1999) is a declarative programming formalism based on the answer-set semantics of logic programs
(Gelfond and Lifschitz 1988). Generating answer sets of propositional programs is the arXiv:1105.0650v1 [cs.AI] 3 May 2011