
## 4 Backjumping And Learning For Sm(Asp)

Nieuwenhuis et al. (2006, Section 2.4) defined the DPLL System with Learning graph that can be used to describe most of the modern SAT solvers, which typically implement such sophisticated techniques as learning and backjumping. We demonstrate how to extend these findings to capture SM(ASP) framework with learning and backjumping.

Let [F,Π] be an SM(ASP) theory and let G be a formula over At(F ∪Π). We say that
[F,Π] entails G, written F,Π |= G, if for every model M of [F,Π], M |= G.

For an SM(ASP) theory [F,Π], an augmented state relative to F and Π is either a distinguished state *FailState* or a pair M||Γ where M is a record relative to the set of atoms occurring in F and Π, and Γ is a set of clauses over At(F ∪Π) such that F,Πo|= Γ.

We now define a graph SML(ASP)F,Π for an SM(ASP) theory [F,Π]. Its nodes are the augmented states relative to F and Π. The rules Decide, *Unfounded*, and *Fail* of SM(ASP)F,Π
are extended to SML(ASP)F,Π as follows: M||Γ =⇒ M′||Γ (M||Γ =⇒ *FailState*, respectively) is an edge in SML(ASP)F,Π justified by Decide or Unfounded (*Fail*, respectively) if and only if M =⇒ M′(M =⇒ *FailState*) is an edge in SM(ASP)F,Π justified by *Decide* or Unfounded *(Fail*, respectively). The other transition rules of SML(ASP)F,Π follow:

$\begin{array}{l}\mbox{$\rm C\,V\,I\in F\cup\Pi^{cd}\cup\Gamma$and}\\ \mbox{$\rm C\,C\,M$}\\ \mbox{$\rm P\,I^{\Delta}\,Q$is inconsistent and}\\ \mbox{$\rm F,\Pi^{o}\,|=I^{\prime}\,\sqrt{P}$}\\ \mbox{$\rm F$every atom in$C$occurs in$F$and}\\ \mbox{$\rm F,\Pi^{o}\,|=C$}.\end{array}$

| Unit Propagate Learn:   | M||Γ =⇒ Ml||Γ if   |  C∨l ∈ F ∪Πcl ∪Γ and C ⊆ M   |
|-------------------------|--------------------|---|
| Backjump:               | Pl∆Q||Γ =⇒ Pl′ ||Γ if  Pl∆Q is inconsistent and F,Πo |= l ′ ∨P                    |   |
| Learn:                  | M||Γ =⇒ M||C, Γ if |  every atom in C occurs in F and F,Πo |= C.   |

We refer to the transition rules Unit Propagate Learn, Unfounded, Backjump, *Decide*, and Fail of the graph SML(ASP)F,Π as basic. We say that a node in the graph is semi-terminal if no rule other than *Learn* is applicable to it. We omit the word "augmented" before "state" when this is clear from a context.

The graph SML(ASP)F,Π can be used for deciding whether an SM(ASP) theory [F,Π]
has a model.

Proposition 9 For any SM(ASP) theory [F,Π],
(a) every path in SML(ASP)F,Π contains only finitely many edges justified by basic transition rules,
(b) for any semi-terminal state M||Γ of SML(ASP)F,Π reachable from /0||/0, M is a model of [F,Π],
(c) *FailState* is reachable from /0||/0 in SML(ASP)F,Π if and only if [F,Π] has no models.

On the one hand, Proposition 9 (a) asserts that if we construct a path from /0||/0 so that basic transition rules periodically appear in it then some semi-terminal state is eventually reached. On the other hand, parts (b) and (c) of Proposition 9 assert that as soon as a semiterminal state is reached the problem of deciding whether [F,Π] has a model is solved.

In other words, Proposition 9 shows that the graph SML(ASP)F,Π gives rise to a class of correct algorithms for computing models of an SM(ASP) theory [F,Π]. It gives a proof