
## Appendix: Proofs 8.1 Proof Of Proposition 2

We start with some additional notation and several lemmas.

Let N be a set of literals. By |N| we denote a set of atoms occurring in N. For instance |{a, ¬b, c}| = {a, b, c}. Further, by ch(N) we denote a set of rules of the form a ← *not not a*, where a ∈ |N|.

By a program literal we mean expressions a, *not a* and *not not a*, where a is an atom.

For a program literal l, we set s(l) = a, if l = a or l = *not not a*, and s(l) = ¬a, if l = *not a*.

For a set B of body literals, we define s(B) = {s(l) | l ∈ B}. If Π is a program and N is a set of literals, by Π(N) we denote the program obtained from Π by removing each rule whose body contains a program literal l such that s(l) ∈ N, and deleting from the bodies of all rules in Π every program literal l such that s(l) ∈ N.

Lemma 1 Let Π be a logic program and N a consistent set of literals such that |N| ∩ *Head*(Π) = /0. For every consistent set M of literals such that |N**| ∩ |**M| = /0,
{a | a ← B ∈ Π∪ch(N) and s(B) ⊆ M ∪N} \N = {a | a ← B ∈ Π(N) and s(B) ⊆ N}·
Proof Let c ∈ {a | a ← B ∈ Π ∪ ch(N) and s(B) ⊆ M ∪ N} \ N. Let c ∈ |N|. The only rule in Π∪ch(N) with c as the head is c ← *not not c*. It follows that c ∈ M∪N. Since |N|∩|M| = /0, c ∈ N, a contradiction. Thus, c ∈ | / N| and there is a rule c ← B ∈ Π such that s(B) ⊆ M ∪N.

Let B
′ be what remains when we remove from B all expressions l such that s(l) ∈ N. The rule c ← B
′ ∈ Π(N) and s(B
′) ⊆ M. It follows that c ∈ {a | a ← B ∈ Π(N) and s(B
′) ⊆ M}.

Conversely, let c ∈ {a | a ← B ∈ Π(N) and s(B) ⊆ M}. It follows that c ∈ | / N| and so, c ∈/ N. Moreover, there is a rule c ← B
′ ∈ Π(N) such that s(B
′) ⊆ M. By the definition of Π(N), there is a rule c ← B ∈ Π such that s(B) ⊆ M ∪ N. Thus, c ∈ {a | a ← B ∈
Π∪ch(N) and s(B) ⊆ M ∪N} \N.

Let N be a set of literals. We define N
− = {a | ¬a ∈ N}.

Lemma 2 For a logic program Π, a consistent set N of literals such that |N| ∩ *Head*(Π) = /0, and a consistent set M of literals such that |M**| ∩ |**N| = /0, GUS(M ∪ N,Π ∪ ch(N)) \ N
− =
GUS(M,Π(N)).

## Proof

We note that since the sets M and N are consistent and |M**| ∩ |**N| = /0, M ∪N is consistent.

Moreover, we note that to prove the claim it suffices to show that U is an unfounded set on M ∪N w.r.t. Π∪ch(N) if and only if U \N
− is an unfounded set on M w.r.t. Π(N).

(⇒) Let a ∈ U \N
− and let D ∈ *Bodies*(Π(N),a). It follows that a ∈ | / N|. It also follows that there is a rule a ← B ∈ Π such that for every program literal l ∈ B, s(l) ∈/ N, and D is obtained by removing from B every program literal l such that s(l) ∈ N.

Since U is an unfounded set on M ∪N w.r.t. Π∪ch(N), it follows that s(B)∩(M ∪N) 6= /0 or U ∩B
+ 6= /0. In the first case, since for every program literal l ∈ B, s(l) ∈/ N, s(B)∩M 6= /0