key step in computation with ASP. The logic FO(ID), introduced by Denecker (2000) is another formalism for declarative programming and knowledge representation. As in the case of ASP, most automated reasoning tasks in the logic FO(ID) reduce to reasoning in its propositional core, the logic PC(ID) (Mari¨en et al. 2008), where generating models is again the key.

In this paper, we show that both computing answer sets of programs and computing models of PC(ID) theories can be considered as testing satisfiability modulo theories (SMT), where the objective is to find a model of a set of clauses that is also an answer set of a certain program. We refer to this computational problem as satisfiability modulo answer-set programming and denote it by SM(ASP). We identify the propositional formalism capturing SM(ASP) - we use the same term to refer to it - and show that it is a common generalization of ASP and PC(ID). We define a simple transition system for SM(ASP) and show that it can be used as an abstract representation of the solver SMODELS1(Niemel¨a and Simons 2000), an alternative to a similar characterization of SMODELS obtained earlier by Lierler (2011). We then define another more elaborate transition system for SM(ASP)
that captures such features of backtracking search as backjumping and learning. We use this transition system to obtain abstract characterizations of the algorithms implemented by the ASP solvers CMODELS2(Giunchiglia et al. 2004) and CLASP3(Gebser et al. 2007),
and the PC(ID) solver MINISAT(ID)
4(Mari¨en et al. 2008). Finally, we briefly mention the possibility to regard the introduced transition systems as proof systems. In that setting, transition systems could be used for comparing the solvers they represent in terms of the complexity of the corresponding proof systems.

Our results provide a uniform correctness proof for a broad class of solvers that can be modeled by the transition system for SM(ASP), clarify essential computational principles behind ASP and PC(ID) solvers, and offer insights into how they relate to each other. In particular, our results yield the first abstract representation of CLASP in terms of transition systems (up to now CLASP has been typically specified in pseudocode), and show that at the abstract level, CLASP and MINISAT(ID) are strikingly closely related.

This last point is noteworthy as the two solvers were developed for different propositional formalisms. MINISAT(ID) was developed specifically for the logic PC(ID), where there is no concept of an answer set. The semantics is a natural extension of the notion of a model of a propositional theory to the setting when a theory consists of propositional clauses and definitions. Definitions are written as logic programs but they are interpreted by the well-founded semantics and not by the answer-set semantics. There is no indication in the literature that CLASP or MINISAT(ID) were influenced by each other. The two solvers were developed independently and for differently motivated formalisms. It is then of substantial interest that at the level of solving they are closely related.