(17) is trivial and is performed in a constant time. Not more than n **nodes can be moved**
in a given iteration. When node i is moved, O(dilog k**) operations are required, where** di is the degree of node i. Summing over all boundary nodes, the complexity is O(m log k)
because Pn i=1 di = 2m**. Hence the number of operations in a single iteration is at most**
O(m log k**). Throughout our experiments we have observed very small number of refinement** iterations even when the refinement is applied to the networks with millions of nodes and edges. Furthermore the algorithm is capable of limiting the number of **iterations. Hence the** complexity of the average number of operations of the whole refinement step does not exceed O(m log k).

The total computational complexity of GANC is dominated by the agglomerative clustering procedure. In practice, the height of the resulting dendrogram is often O(log n**). Also,** the graphs that are studied are usually sparse and hence m = O(n). Therefore the complexity of the agglomerative clustering step of our algorithm is O(n log2 n**) for many real-life**
graphs.

The worst case runtime happens when the graph is complete and the **dendrogram is**
totally unbalanced. There are n − **1 agglomerations to construct the whole hierarchy each**
of which requires at most O(n log n**) operations. Hence the worst case complexity for the**
agglomerative clustering step of the algorithm is O(n 2log n**) which is not expected to occur**
in practical situations.

The memory requirement of GANC is O(m) which is equivalent to O(n**) for sparse graphs.**
In summary, in many practical cases (relatively sparse graphs and **balanced dendrograms),**
the computational complexity is O(n log2 n) and the memory requirement is O(n**). GANC** can be downloaded from http://www.ece.mcgill.ca/~coates/software/.

## 5. Experimental Results

In this section we provide a comparison of the performance and the **runtime of our**
proposed algorithm GANC with a selection of the state-of-the-art **graph clustering algorithms**
from the literature whose implementations were downloaded from the corresponding authors' websites. Experiments were performed on an Intel 3.0 GHz Core 2 Quad CPU with 8 GB
of RAM and Ubuntu 9.10 operating system.

5.1. Comparing Algorithms We compare to the following algorithms: Shi and Malik (recursive NCut) [9]; Meila and Shi (k-way NCut) [18]; Ng, Jordan, and Weiss [19]; Dhillon, Gaun, and Kulis [11]; Rosvall and Bergstrom [7]; and Blondel et al. [56]. The first four algorithms focus on maximizing NAssoc. Despite not addressing our criterion of interest directly, **the other algorithms are** included because they are scalable and represent the state-of-the-art in graph clustering.

The discussed clustering algorithms ([9],[18],[19]) are not scalable as they include eigendecomposition. Dhillon, Guan, and Kulis proposed an algorithm that strives to maximize normalized association without requiring any eigendecomposition [11]. **Similar to the other** algorithms that address the maximization of normalized association, **the Dhillon-Guan-Kulis**
algorithm requires the user to provide the number of clusters. After specifying the number of clusters, three steps are performed: a coarsening phase, a base clustering step using region growing, and finally a refinement step using weighted kernel k-means with appropriate choices of the kernel and the node weights to maximize the normalized association.