number of clusters.

Note that Figure 3 corresponds to a single realization of the LFR benchmarks. The empirical probabilities that the highest peak of the curvature corresponds to the true number of clusters for 100 realizations of the LFR benchmark with parameters as in Figure 3 are p1 = [1.0 1.0 0.96 0.60 0.42 0.06], for µ = [0.1 0.2 0.3 0.4 0.5 0.**6] when no refinement**
step is applied; furthermore the empirical probabilities that one of the two highest peaks corresponds to the true number of clusters are p2 = [1.0 1.0 1.0 0.98 0.75 0.**13].**
These probabilities are obtained using the approximate curvatures derived from the agglomerative clustering procedure. To achieve a better insight into the model selection capabilities of the curvature metric, we derive better approximations by **applying the refinement**
step to every level of the hierarchy and then recomputing curvature estimates. With this new procedure, we obtain p1 = [1.0 0.99 0.99 0.95 0.87 0.77] and p2 = [1.0 0.99 0.99 0.96 0.88 0.**78].**
This indicates that curvature can provide a good indication of model order even for µ = 0.6.

The model order selection algorithm of Rosvall-Bergstrom algorithm **quite successfully**
indicates the true number of clusters in the case of LFR benchmarks; the empirical probabilities for the Rosvall-Bergstrom algorithm is p1 = [1.0 1.0 1.0 0.98 0.85 0.**83]. The Blondel**
et al. algorithm does not successfully identify the true number of clusters when µ **increases:**
p1 = [1.0 0.99 0.98 0.79 0.07 0.0]. Note that when n = 5, **000, the failure of the Blondel et al.** algorithm becomes more evident and p1 turns to a 0% success for any µ **(this is reflected in**
Figure 1). However the refined GANC and Rosvall-Bergstrom algorithms obtain the same success ratios when n = 5, **000.**

## 5.4. Real Networks

In this section, we examine the behavior the GANC and compare it to the other algorithms for graphs representing real networks. We first examine the behavior for small networks where there is knowledge of the ground truth partition. **We then experiment with** large networks, which allows us to assess the scalability of GANC.

## 5.4.1. Small Networks

We conduct experiments using the Zachary karate club network [65], the football network
[6], and the political books network10**. The Zachary karate club network portrays friendships**
in a karate club. During the polling period, there was a dispute between the manager and the instructor which led to the establishment of a new club by the instructor. The karate students then split into two groups, either staying with the original **club or following the** instructor to the new club. The two clusters associated with the network correspond to these two groups. Each node in the football networks corresponds to a **team in US college football.** There are 11 conferences and 5 independent teams. Each edge corresponds to the existence of a match between the connected nodes. The independent teams **can be interpreted as**
outliers. Nodes of the political book network correspond to the political books sold by Amazon.com and are categorized as neutral, conservative, and liberal. The edges between pairs of nodes correspond to frequent co-buying of the pairs of books by the same buyers.

The three networks are unweighted.

10**Collected by V. Krebs,** http://www.orgnet.com