
## 5.4.2. Cortical Networks

Here we study the networks presented in [66] which are weighted graphs, each with 998 nodes. The nodes correspond to small regions of the human cerebral cortex and the edges correspond to cortico-cortical axonal pathways. The networks are developed for five patients
(the extraction is performed twice for patient A). We first perform a comparison of the competing algorithms, then we discuss the clustering results of GANC.

When applying the Rosvall-Bergstrom and Blondel et al. algorithms the used does not have the freedom to choose the number of clusters. Hence we repeat the experiment twice to make a meaningful objective comparison in terms of NAssoc. Table 3 lists the average NAssoc of every clustering algorithm and patient. In the first subtable, k **is set to the** model order selected by the Rosvall-Bergstrom algorithm. Then, in **the second subtable,** k is set to the model order selected by the Blondel et al. algorithm, and in the third subtable, peaks of the model order selected by curvature are used. Note that the Shi-Malik algorithm outperforms the other two spectral algorithms for these datasets; hence we only include the Shi-Malik results.

| A-1                | A-2        | B          | C          | D          | E          |            |
|--------------------|------------|------------|------------|------------|------------|------------|
| Rosvall-Bergstrom  | 0.725 (62) | 0.706 (68) | 0.738 (61) | 0.706 (62) | 0.691 (63) | 0.706 (58) |
| GANC (refined)     | 0.730      | 0.716      | 0.740      | 0.712      | 0.705      | 0.718      |
| Dhillon-Guan-Kulis | 0.696      | 0.682      | 0.712      | 0.688      | 0.670      | 0.684      |
| Shi-Malik          | 0.715      | 0.692      | 0.727      | 0.690      | 0.686      | 0.694      |
| Blondel et al.     | 0.873 (14) | 0.872 (13) | 0.885 (15) | 0.862 (14) | 0.856 (14) | 0.828 (21) |
| GANC (refined)     | 0.886      | 0.879      | 0.883      | 0.873      | 0.864      | 0.840      |
| Dhillon-Guan-Kulis | 0.860      | 0.865      | 0.872      | 0.859      | 0.851      | 0.810      |
| Shi-Malik          | 0.877      | 0.874      | 0.877      | 0.860      | 0.870      | 0.826      |
| GANC (refined)     | 0.908 (10) | 0.945 (4)  | 0.899 (12) | 0.880 (13) | 0.930 (5)  | 0.907(9)   |
| Dhillon-Guan-Kulis | 0.889      | 0.946      | 0.897      | 0.863      | 0.916      | 0.885      |
| Shi-Malik          | 0.898      | 0.951      | 0.886      | 0.863      | 0.936      | 0.902      |

The clustering results corresponding to the curvature peaks include cluster(s) that contain nodes from both of the brain hemispheres and clusters that include **nodes from only one of** the hemispheres. In the following discussion, we call the clusters that contain nodes from both of the hemispheres, the central clusters. Graphs A1, B, D, **and E include only one** central cluster. Graphs A2 and C each include two central clusters.

The regions of the brain that are commonly grouped in the central clusters are posterior cingulate cortex, precuneus, cuneus, paracentral lobule, pericalcarine cortex, caudal anterior cingulate cortex, isthmuscingulate, isthmus of the cingulate cortex, and lingual gyrus, provided that graph B is excluded. If the second largest peak of the curvature is selected for B
(k **= 5), the same regions are assigned to its central cluster. The first five of the mentioned**
regions are also classified as part of the structural core proposed by Hagmann et al. [66]; Hagmann et al. used cluster strengths, cluster degrees, k-Core, s-Core, betweenness centrality,