connections between nodes. On the other hand, clustering algorithms based on Markov random walks [7, 8] also value indirect connections and network flow. In this paper we select the normalized cut criterion [9], which simultaneously encourages intra-cluster similarity while penalizing inter-cluster similarities. Methods based on this criterion have been employed successfully in a wide range of applications [5, 8–12]. The normalized cut criterion is related to the conductance of the underlying graph [13]. Furthermore an **implicit duality between**
normalized cut and normalized association exists; the former encourages clusters that are less connected to each other and the latter encourages clusters whose nodes are well-connected.

When partitioning a graph into clusters, the cut associated with cluster i **is the sum**
of the weights of the edges between nodes in i **and nodes in other clusters. Intuitively,** minimizing the maximum cut (or minimizing the average cut) identifies clusters that have the weakest ties between them. The problem is that the minimum cut will often be achieved by identifying many very small clusters, which provides little insight into the underlying structure of the graph. The normalized cut metric was introduced **by Shi and Malik in [9]** to address this shortcoming. It normalizes each cut by dividing it by the total weight of the associated cluster. This has the effect of penalizing very small clusters because they generally have low total weight.

Minimizing normalized cut is an NP-complete problem [9]. Shi and Malik illustrated that the minimization could be relaxed to form a generalized eigenvalue **system, whose (discretized) solution corresponds to the minimum normalized cut. This has led to the development of a spectral clustering; it involves calculating eigenvectors of the identified system. In**
order to identify a partitioning of n nodes to k **clusters, some techniques perform recursive** bipartitioning [9], and thus require the repeated identification of two **eigenvectors. Other** approaches strive to identify k clusters directly by calculating the k **smallest eigenvectors of** the underlying graph Laplacian. One of the concerns about these methods is computational complexity; even when employing fast eigendecomposition methods such as the Lanczos iterative technique, complexity grows rapidly with n.

In this paper, we propose an agglomerative clustering algorithm that strives to minimize the normalized cut (or equivalently, maximize the normalized association). It is a fast, scalable algorithm, with almost linear complexity in the number of nodes **for relatively** sparse graphs. Performance evaluation using a range of benchmark and observed graphs indicates that the algorithm identifies partitionings that have average normalized association metrics as large as those of the partitions identified by the spectral clustering techniques.

We also propose a method for identifying important partitioning scales which can be used to automatically select the number of clusters. To the best of our knowledge, this is the first model order selection method applicable to the normalized association maximization that is scalable. Through our experiments, we will show how effective our model order selection criterion is for both synthetic and real networks.

The rest of the paper is organized as follows. In Section 2 the major **approaches for minimization of normalized cut and model order selection are reviewed. The problem formulation**
of normalized association is re-stated in Section 3. Our proposed algorithm is detailed in Section 4. The proposed algorithm is then compared to the state-of-the-art clustering algorithms in Section 5. The concluding remarks are provided in Section 6.