Table 4 compares the performance of the algorithms that are scalable to such large networks. The table shows the average NAssoc per cluster of the **identified partitioning** and the time required for completion of the algorithm. The spectral **clustering algorithms**
cannot be executed on our test machine when either the number of **nodes or the number**
of clusters is very large. Both the computational time and the memory requirements are excessive. We therefore compare the performance of GANC, Dhillon-Guan-Kulis (no local search), Rosvall-Bergstrom, and the Blondel et al. algorithms.

The Rosvall-Bergstrom and Blondel et al. algorithms automatically select the number of clusters. A meaningful comparison of the average NAssoc is only possible when the number of clusters are equal; to facilitate comparisons, we therefore construct multiple partitionings for GANC and the Dhillon-Guan-Kulis algorithms, each with a different number of clusters. We also construct a partitioning corresponding to one or more of the peaks in the curvature plot (for some of the networks, there are two peaks that are very similar in value, so we consider it useful to examine the partitionings corresponding to each). The last two rows of Table 4 correspond to those peaks.

GANC is superior to other algorithms with respect to maximizing NAssoc in all of the cases. GANC also significantly outperforms the Dhillon-Guan-Kulis algorithm, which is also striving to maximize NAssoc. The latter is also outperformed by Rosvall-Bergstrom and Blondel et al. algorithms.

In terms of the computation time, GANC is often faster than Rosvall-Bergstrom, but the scaling behavior is different. To illustrate this, in addition to the graphs listed in Table 1, we have applied the algorithms to the road network graph of California [60] which is extremely sparse (the average degree is 2.8). The graph contains around 2 million nodes. While GANC
performs the clustering in 32 seconds, in takes 197 minutes for the **Rosvall-Bergstrom algorithm to converge to a solution. The complexity of GANC is dominated by the agglomerative** clustering procedure which requires O(mh log n**) operations. Hence the speed of GANC depends on the number of edges in the graph, and the height of the dendrogram. However the**
graph sparsity does not show an impact on Rosvall-Bergstrom's execution time. Blondel's algorithm is much faster than GANC, but as mentioned previously, it suffers from resolution limit associated with clustering algorithms that maximize modularity. The Dhillon-GuanKulis algorithm is also very fast for small values of k**, but it gets slower and its memory**
requirements become excessive if k **becomes large.**
To illustrate the properties of the algorithm outputs in terms of the **cluster sizes and**
the connectivity of individual clusters, we have examined the plots of NAssoc of individual clusters versus the number of nodes in them. Each algorithm behaves similarly on different graphs presented in Table 4. Figure 4a compares GANC and Rosvall-Bergstrom when applying these algorithms on Amazon co-purchasing graph. For the **same number of clusters, GANC produces clusters with higher values of NAssoc than Rosvall-Bergstrom. The**
latter produces many small clusters with very low values of NAssoc. **The behavior of the** Dhillon-Guan-Kulis and the Blondel et al. algorithms are discussed in our case study.

## 5.5. Case Study: Us Patent Citation Graph

As a case study, we consider the undirected version of the citation **graph released by**
the National Bureau of Economic Research [70, 71]. The patents are classified into 6 broad technological categories. A more refined classification leads to 36 sub-categories. We use