
## 6. Conclusion

We proposed a novel algorithm to maximize normalized association that consists of three steps: the agglomerative hierarchical clustering procedure, the **model order selection step,**
and the refinement step.

The agglomerative clustering procedure requires O(n log2 n**) operations for many real-life**
graphs, where n **is the number of nodes in the graph. This procedure dominates the computational complexity of the other steps of the algorithm. The second step of our algorithm, the**
model order selection, is based on the relative improvement of normalized association when changing the number of clusters; the *curvature* **plot is used to select one or several model**
orders for the final clustering. Unlike modularity, the curvature metric does not exhibit an intrinsic resolution limit. For a multi-resolution analysis, a user can specify a range on the allowable number of clusters, and the algorithm will select the number **of clusters with the** maximum curvature in that range. After selecting the number of clusters, the clusters are passed to the refinement step. This step of our algorithm iterates **over the boundary nodes in** the clusters and explores possible improvements in normalized association by moving each of the boundary nodes to their neighboring clusters. Using the map **data structure, the** overhead added by the refinement becomes negligible. Experiments **show that despite the**
negligible runtime of the refinement step, it significantly improves the **initial results with** respect to the normalized association maximization.

Our experimental analysis on relatively small networks indicated that the proposed algorithm identified partitions that have normalized association values comparable to the spectral algorithms that involve an eigendecomposition. These algorithms are **too computationally**
complex to be applied to very large graphs. We demonstrated that our proposed algorithm can be applied to large graphs (millions of nodes and edges). For these large graphs, the proposed algorithm identifies partitions that have larger values of normalized association than those identified by the only comparable algorithm that directly addresses the normalized cut metric.

A clustering algorithm can by no means be suitable for every application. For example, despite the failure of Dhillon-Guan-Kulis algorithm to extract clusters with nodes of the same categories in the patent citation network, it generates clusters of very similar sizes. This is more suitable for VLSI applications for instance [72]. On the other hand, when clustering is meant to extract "communities" (group of nodes with strong intra-connection), GANC and Rosvall-Bergstrom are clearly preferred.

The Blondel et al. and Rosvall-Bergstrom algorithms are not able to generate a partitioning to an arbitrary number of clusters15**; even though they are agglomerative, they do**
not generate the complete hierarchy because they merge several nodes/clusters in each of their iterations. Hence if one is interested in several arbitrary clustering levels, GANC fits one's requirement the best out of the competing algorithms discussed.

In this paper we only considered undirected graphs while the edge directions could carry valuable information about the structure of a graph. An extension **of GANC can be developed**
by adopting the *generalized normalized cut* **criterion [73].**