of [45] propose a similar approach. The main drawback of these approaches is that only the granularity of the clusters are taken into account and the number **and the weights of the** edges are simply ignored.

A well-known and effective method of selecting the number of clusters is to examine the eigenvalues of the Laplacian of the graph that is to be clustered [19, **47, 48]. For a graph with** isolated connected components the multiplicity of the eigenvalue zero is equal to the number of clusters. Any other graph with well-separated clusters can be considered as a perturbation of this ideal case. Matrix perturbation theory states that the stability of the eigenvectors of a matrix is proportional to the eigengap (the difference between two successive eigenvalues). Von Luxburg [48] suggests using k
∗ = arg maxk (λk − λk+1**). A large eigengap at** k
∗
**is the**
case in which spectral algorithms using the Laplacian perform most successfully [19]. A more robust criterion is proposed by Zelnik-Manor and Perona [49] **that uses eigenvectors** instead. Despite the solid theoretical support behind these approaches, the requirement of eigendecomposition makes them impractical when large graphs are being clustered.

There have been attempts to identify the number of clusters using **stability analysis.**
"Stability" has been defined differently by different authors, but they all based on the same intuition; with respect to some algorithm, a stable clustering is one that behaves relatively consistently in the presence of some controlled perturbation. The **perturbation could be in** terms of noise [50], sampling subsets from the input [51, 52], or random projection of a high dimensional data into a lower dimensional space [53]. These approaches require several runs of clustering for every value of k **which makes them computationally expensive. Furthermore,**
Ben-David et al. [52] warn against using stability analysis in this context, and they suggest that this family of model order selection techniques is not suitable for selecting the number of clusters in general. The intuition behind their work is that when an underlying objective function, F(k**), has several local optima of relatively similar values, a clustering algorithm** might be trapped by any of them, even when k **is the true number of clusters. The difference** in clustering solutions is interpreted as instability and the model order rejected, but the behavior is caused by the imperfect nature of the clustering algorithm.

Two more recently proposed methods to select the number of clusters are based on optimization of the quality metrics of modularity [6] and description length [7]. Both methods simultaneously address both clustering and the selection of the number of clusters; they strive to optimize the objective function over all possible partitionings. These methods are discussed in more detail in Section 5.

## 3. Problem Formulation

Let G = (V, E, w) be a weighted graph having n = |V | nodes and m = |E| **edges**4.

We assume that edge weights w(u, v) = w(v, u) ≥ **0 are non-negative and symmetric, that**
w(u, v) = 0 if (u, v) ∈/ E, and that for (u, v) ∈ E, the weight w(u, v) ≥ **0 is indicative of the** similarity between nodes u and v**; that is, the larger the weight, the more similar the nodes.** We also allow for self-weights, w(**u, u**) ≥ 0.